/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.io.Resource;
import infra.core.io.UrlResource;
import infra.http.server.PathContainer;
import infra.lang.Assert;
import infra.web.handler.function.ServerRequest;
import infra.web.resource.ResourceHandlerUtils;
import infra.web.util.UriUtils;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PathPatternParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;

class PathResourceLookupFunction
implements Function<ServerRequest, Optional<Resource>> {
    private final PathPattern pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        ResourceHandlerUtils.assertResourceLocation(location);
        this.pattern = PathPatternParser.defaultInstance.parse(pattern);
        this.location = location;
    }

    @Override
    public Optional<Resource> apply(ServerRequest request) {
        PathContainer pathContainer = request.requestPath().pathWithinApplication();
        if (!this.pattern.matches(pathContainer)) {
            return Optional.empty();
        }
        String path = ResourceHandlerUtils.normalizeInputPath((pathContainer = this.pattern.extractPathWithinPattern(pathContainer)).value());
        if (ResourceHandlerUtils.shouldIgnoreInputPath(path)) {
            return Optional.empty();
        }
        if (!(this.location instanceof UrlResource)) {
            path = UriUtils.decode(path, StandardCharsets.UTF_8);
        }
        try {
            Resource resource = this.location.createRelative(path);
            if (resource.isReadable() && ResourceHandlerUtils.isResourceUnderLocation(this.location, resource)) {
                return Optional.of(resource);
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return this.pattern + " -> " + this.location;
    }
}

