/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.handler.function.AbstractServerResponse;
import infra.web.handler.function.RenderingResponse;
import infra.web.handler.function.ServerResponse;
import infra.web.view.ModelAndView;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;

final class ModelAndViewRenderingResponseBuilder
implements RenderingResponse.ViewBuilder {
    private final ModelAndView modelAndView;
    private HttpStatusCode status = HttpStatus.OK;
    private final HttpHeaders headers = HttpHeaders.forWritable();
    private final LinkedMultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();

    public ModelAndViewRenderingResponseBuilder(ModelAndView modelAndView) {
        Assert.notNull((Object)modelAndView, (String)"ModelAndView is required");
        this.modelAndView = modelAndView;
    }

    @Override
    public RenderingResponse.ViewBuilder status(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        this.status = status;
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder status(int status) {
        return this.status(HttpStatusCode.valueOf(status));
    }

    @Override
    public RenderingResponse.ViewBuilder cookie(HttpCookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie is required");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder cookie(String name, String ... values) {
        for (String value : values) {
            this.cookies.add((Object)name, (Object)new HttpCookie(name, value));
        }
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder cookies(Consumer<MultiValueMap<String, HttpCookie>> cookiesConsumer) {
        cookiesConsumer.accept((MultiValueMap<String, HttpCookie>)this.cookies);
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder cookies(@Nullable Collection<HttpCookie> cookies) {
        if (CollectionUtils.isNotEmpty(cookies)) {
            for (HttpCookie cookie : cookies) {
                this.cookies.add((Object)cookie.getName(), (Object)cookie);
            }
        }
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder cookies(@Nullable MultiValueMap<String, HttpCookie> cookies) {
        this.cookies.setAll(cookies);
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder header(String headerName, String ... headerValues) {
        this.headers.setOrRemove(headerName, headerValues);
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public RenderingResponse.ViewBuilder headers(@Nullable HttpHeaders headers) {
        this.headers.setAll((Map)((Object)headers));
        return this;
    }

    @Override
    public RenderingResponse build() {
        return new ModelAndViewRenderingResponse(this.status, this.headers, (MultiValueMap<String, HttpCookie>)this.cookies, this.modelAndView);
    }

    static class ModelAndViewRenderingResponse
    extends AbstractServerResponse
    implements RenderingResponse {
        private final ModelAndView modelAndView;

        public ModelAndViewRenderingResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, ModelAndView modelAndView) {
            super(statusCode, headers, cookies);
            this.modelAndView = modelAndView;
        }

        @Override
        public String name() {
            return this.modelAndView.getViewName();
        }

        @Override
        public Map<String, Object> model() {
            return this.modelAndView.getModel();
        }

        @Override
        protected Object writeToInternal(RequestContext request, ServerResponse.Context context) {
            if (this.modelAndView.getStatus() == null) {
                this.modelAndView.setStatus(this.statusCode());
            }
            return this.modelAndView;
        }
    }
}

