/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.lang.Assert;
import infra.web.handler.function.ErrorHandlingServerResponse;
import infra.web.handler.function.HandlerFunction;
import infra.web.handler.function.ServerRequest;
import infra.web.handler.function.ServerResponse;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface HandlerFilterFunction<T extends ServerResponse, R extends ServerResponse> {
    public R filter(ServerRequest var1, HandlerFunction<T> var2) throws Exception;

    default public HandlerFilterFunction<T, R> andThen(HandlerFilterFunction<T, T> after) {
        Assert.notNull(after, (String)"HandlerFilterFunction is required");
        return (request, next) -> {
            HandlerFunction<ServerResponse> nextHandler = handlerRequest -> after.filter(handlerRequest, next);
            return this.filter(request, nextHandler);
        };
    }

    default public HandlerFunction<R> apply(HandlerFunction<T> handler) {
        Assert.notNull(handler, (String)"HandlerFunction is required");
        return request -> this.filter(request, handler);
    }

    public static <T extends ServerResponse> HandlerFilterFunction<T, T> ofRequestProcessor(Function<ServerRequest, ServerRequest> requestProcessor) {
        Assert.notNull(requestProcessor, (String)"Function is required");
        return (request, next) -> next.handle((ServerRequest)requestProcessor.apply(request));
    }

    public static <T extends ServerResponse, R extends ServerResponse> HandlerFilterFunction<T, R> ofResponseProcessor(BiFunction<ServerRequest, T, R> responseProcessor) {
        Assert.notNull(responseProcessor, (String)"Function is required");
        return (request, next) -> (ServerResponse)responseProcessor.apply(request, next.handle(request));
    }

    public static <T extends ServerResponse> HandlerFilterFunction<T, T> ofErrorHandler(Predicate<Throwable> predicate, BiFunction<Throwable, ServerRequest, T> errorHandler) {
        Assert.notNull(predicate, (String)"Predicate is required");
        Assert.notNull(errorHandler, (String)"ErrorHandler is required");
        return (request, next) -> {
            try {
                Object t = next.handle(request);
                if (t instanceof ErrorHandlingServerResponse) {
                    ((ErrorHandlingServerResponse)t).addErrorHandler(predicate, errorHandler);
                }
                return t;
            }
            catch (Throwable throwable) {
                if (predicate.test(throwable)) {
                    return (ServerResponse)errorHandler.apply(throwable, request);
                }
                throw throwable;
            }
        };
    }
}

