/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.RequestContext;
import infra.web.handler.function.ServerRequest;
import infra.web.handler.function.ServerResponse;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Predicate;

abstract class ErrorHandlingServerResponse
implements ServerResponse {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ArrayList<ErrorHandler<?>> errorHandlers = new ArrayList();

    ErrorHandlingServerResponse() {
    }

    protected final <T extends ServerResponse> void addErrorHandler(Predicate<Throwable> predicate, BiFunction<Throwable, ServerRequest, T> errorHandler) {
        Assert.notNull(predicate, (String)"Predicate is required");
        Assert.notNull(errorHandler, (String)"ErrorHandler is required");
        this.errorHandlers.add(new ErrorHandler<T>(predicate, errorHandler));
    }

    @Nullable
    protected final Object handleError(Throwable t, RequestContext request, ServerResponse.Context context) throws Throwable {
        ServerResponse serverResponse = this.errorResponse(t, request);
        if (serverResponse != null) {
            return serverResponse.writeTo(request, context);
        }
        throw t;
    }

    @Nullable
    protected final ServerResponse errorResponse(Throwable t, RequestContext request) {
        for (ErrorHandler<?> errorHandler : this.errorHandlers) {
            if (!errorHandler.test(t)) continue;
            ServerRequest serverRequest = ServerRequest.findRequired(request);
            return errorHandler.handle(t, serverRequest);
        }
        return null;
    }

    private static class ErrorHandler<T extends ServerResponse> {
        private final Predicate<Throwable> predicate;
        private final BiFunction<Throwable, ServerRequest, T> responseProvider;

        public ErrorHandler(Predicate<Throwable> predicate, BiFunction<Throwable, ServerRequest, T> responseProvider) {
            Assert.notNull(predicate, (String)"Predicate is required");
            Assert.notNull(responseProvider, (String)"ResponseProvider is required");
            this.predicate = predicate;
            this.responseProvider = responseProvider;
        }

        public boolean test(Throwable t) {
            return this.predicate.test(t);
        }

        public T handle(Throwable t, ServerRequest serverRequest) {
            return (T)((ServerResponse)this.responseProvider.apply(t, serverRequest));
        }
    }
}

