/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.ParameterizedTypeReference;
import infra.http.CacheControl;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.web.handler.function.DefaultEntityResponseBuilder;
import infra.web.handler.function.ServerResponse;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;

public interface EntityResponse<T>
extends ServerResponse {
    public T entity();

    public static <T> Builder<T> fromObject(T t) {
        return new DefaultEntityResponseBuilder<T>(t, null);
    }

    public static <T> Builder<T> fromObject(T t, ParameterizedTypeReference<T> entityType) {
        return new DefaultEntityResponseBuilder<T>(t, entityType.getType());
    }

    public static interface Builder<T> {
        public Builder<T> header(String var1, String ... var2);

        public Builder<T> headers(Consumer<HttpHeaders> var1);

        public Builder<T> headers(@Nullable HttpHeaders var1);

        public Builder<T> status(HttpStatusCode var1);

        public Builder<T> status(int var1);

        public Builder<T> cookie(HttpCookie var1);

        public Builder<T> cookie(String var1, String ... var2);

        public Builder<T> cookies(Consumer<MultiValueMap<String, HttpCookie>> var1);

        public Builder<T> cookies(@Nullable Collection<HttpCookie> var1);

        public Builder<T> cookies(@Nullable MultiValueMap<String, HttpCookie> var1);

        public Builder<T> allow(HttpMethod ... var1);

        public Builder<T> allow(Set<HttpMethod> var1);

        public Builder<T> eTag(@Nullable String var1);

        public Builder<T> lastModified(ZonedDateTime var1);

        public Builder<T> lastModified(Instant var1);

        public Builder<T> location(URI var1);

        public Builder<T> cacheControl(CacheControl var1);

        public Builder<T> varyBy(String ... var1);

        public Builder<T> contentLength(long var1);

        public Builder<T> contentType(MediaType var1);

        public EntityResponse<T> build();
    }
}

