/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.ParameterizedTypeReference;
import infra.http.CacheControl;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.handler.function.AbstractServerResponse;
import infra.web.handler.function.DefaultEntityResponseBuilder;
import infra.web.handler.function.DefaultRenderingResponseBuilder;
import infra.web.handler.function.ModelAndViewRenderingResponseBuilder;
import infra.web.handler.function.ServerResponse;
import infra.web.handler.function.StreamingServerResponse;
import infra.web.view.ModelAndView;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

class DefaultServerResponseBuilder
implements ServerResponse.BodyBuilder {
    private final HttpStatusCode statusCode;
    private final HttpHeaders headers = HttpHeaders.forWritable();
    private final MultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();

    public DefaultServerResponseBuilder(ServerResponse other) {
        Assert.notNull((Object)other, (String)"ServerResponse is required");
        this.statusCode = other.statusCode();
        this.headers.addAll((Map)((Object)other.headers()));
        this.cookies.addAll(other.cookies());
    }

    public DefaultServerResponseBuilder(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        this.statusCode = status;
    }

    @Override
    public ServerResponse.BodyBuilder header(String headerName, String ... headerValues) {
        this.headers.setOrRemove(headerName, headerValues);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder headers(@Nullable HttpHeaders headers) {
        this.headers.setAll((Map)((Object)headers));
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookie(HttpCookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie is required");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookie(String name, String ... values) {
        for (String value : values) {
            this.cookies.add((Object)name, (Object)new HttpCookie(name, value));
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookies(Consumer<MultiValueMap<String, HttpCookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookies(@Nullable Collection<HttpCookie> cookies) {
        if (CollectionUtils.isNotEmpty(cookies)) {
            for (HttpCookie cookie : cookies) {
                this.cookies.add((Object)cookie.getName(), (Object)cookie);
            }
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookies(@Nullable MultiValueMap<String, HttpCookie> cookies) {
        this.cookies.setAll(cookies);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder eTag(@Nullable String etag) {
        this.headers.setETag(etag);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(ZonedDateTime lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(Instant lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cacheControl(CacheControl cacheControl) {
        this.headers.setCacheControl(cacheControl);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public ServerResponse build() {
        return this.build(request -> null);
    }

    @Override
    public ServerResponse build(ServerResponse.HeadersBuilder.WriteFunction writeFunction) {
        return new WriteFunctionResponse(this.statusCode, this.headers, this.cookies, writeFunction);
    }

    @Override
    public ServerResponse body(Object body) {
        return new DefaultEntityResponseBuilder<Object>(body, null).status(this.statusCode).headers(this.headers).cookies(this.cookies).build();
    }

    @Override
    public <T> ServerResponse body(T body, ParameterizedTypeReference<T> bodyType) {
        return new DefaultEntityResponseBuilder<T>(body, bodyType.getType()).status(this.statusCode).headers(this.headers).cookies(this.cookies).build();
    }

    @Override
    public ServerResponse render(String name, Object ... modelAttributes) {
        return new DefaultRenderingResponseBuilder(name).status(this.statusCode).headers(this.headers).cookies(this.cookies).modelAttributes(modelAttributes).build();
    }

    @Override
    public ServerResponse render(String name, Map<String, ?> model) {
        return new DefaultRenderingResponseBuilder(name).status(this.statusCode).headers(this.headers).cookies(this.cookies).modelAttributes(model).build();
    }

    @Override
    public ServerResponse render(ModelAndView modelAndView) {
        return new ModelAndViewRenderingResponseBuilder(modelAndView).status(this.statusCode).headers(this.headers).cookies(this.cookies).build();
    }

    @Override
    public ServerResponse stream(Consumer<ServerResponse.StreamBuilder> streamConsumer) {
        return StreamingServerResponse.create(this.statusCode, this.headers, this.cookies, streamConsumer, null);
    }

    private static class WriteFunctionResponse
    extends AbstractServerResponse {
        private final ServerResponse.HeadersBuilder.WriteFunction writeFunction;

        public WriteFunctionResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, ServerResponse.HeadersBuilder.WriteFunction writeFunction) {
            super(statusCode, headers, cookies);
            Assert.notNull((Object)writeFunction, (String)"WriteFunction is required");
            this.writeFunction = writeFunction;
        }

        @Override
        @Nullable
        protected Object writeToInternal(RequestContext request, ServerResponse.Context context) throws Throwable {
            return this.writeFunction.write(request);
        }
    }
}

