/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.ParameterizedTypeReference;
import infra.core.ResolvableType;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRange;
import infra.http.MediaType;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.server.RequestPath;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MimeTypeUtils;
import infra.util.MultiValueMap;
import infra.validation.BindException;
import infra.validation.BindingResult;
import infra.web.HttpMediaTypeNotSupportedException;
import infra.web.RequestContext;
import infra.web.async.AsyncWebRequest;
import infra.web.bind.WebDataBinder;
import infra.web.handler.function.RouterFunctions;
import infra.web.handler.function.ServerRequest;
import infra.web.handler.function.ServerResponse;
import infra.web.multipart.Multipart;
import infra.web.multipart.MultipartRequest;
import infra.web.util.UriBuilder;
import infra.web.util.UriComponentsBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;

class DefaultServerRequest
implements ServerRequest {
    private final ServerRequest.Headers headers;
    private final RequestPath requestPath;
    private final RequestContext requestContext;
    private final Map<String, Object> attributes;
    private final MultiValueMap<String, String> params;
    private final List<HttpMessageConverter<?>> messageConverters;
    @Nullable
    private MultiValueMap<String, Multipart> parts;

    DefaultServerRequest(RequestContext requestContext, List<HttpMessageConverter<?>> messageConverters) {
        this.requestContext = requestContext;
        this.params = requestContext.getParameters();
        this.requestPath = requestContext.getRequestPath();
        this.messageConverters = List.copyOf(messageConverters);
        this.attributes = requestContext.getAttributes();
        this.headers = new DefaultRequestHeaders(requestContext.getHeaders());
    }

    @Override
    public HttpMethod method() {
        return this.requestContext.getMethod();
    }

    @Override
    public String methodName() {
        return this.requestContext.getMethodValue();
    }

    @Override
    public URI uri() {
        return this.requestContext.getURI();
    }

    @Override
    public UriBuilder uriBuilder() {
        return UriComponentsBuilder.fromHttpRequest(this.requestContext);
    }

    @Override
    public RequestPath requestPath() {
        return this.requestPath;
    }

    @Override
    public ServerRequest.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, HttpCookie> cookies() {
        HttpCookie[] cookies = this.requestContext.getCookies();
        if (cookies == null) {
            cookies = new HttpCookie[]{};
        }
        LinkedMultiValueMap result = new LinkedMultiValueMap(cookies.length);
        for (HttpCookie cookie : cookies) {
            result.add((Object)cookie.getName(), (Object)cookie);
        }
        return result;
    }

    @Override
    public RequestContext exchange() {
        return this.requestContext;
    }

    @Override
    public Optional<InetSocketAddress> remoteAddress() {
        return Optional.of(new InetSocketAddress(this.requestContext.getRemoteAddress(), this.requestContext.getServerPort()));
    }

    @Override
    public List<HttpMessageConverter<?>> messageConverters() {
        return this.messageConverters;
    }

    @Override
    public <T> T body(Class<T> bodyType) throws IOException {
        return this.bodyInternal(bodyType, bodyType);
    }

    @Override
    public <T> T body(ParameterizedTypeReference<T> bodyType) throws IOException {
        Type type = bodyType.getType();
        return this.bodyInternal(type, DefaultServerRequest.bodyClass(type));
    }

    static Class<?> bodyClass(Type type) {
        ParameterizedType parameterizedType;
        Type type2;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType && (type2 = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class rawType = (Class)type2;
            return rawType;
        }
        return Object.class;
    }

    private <T> T bodyInternal(Type bodyType, Class bodyClass) throws IOException {
        MediaType contentType = this.headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
        for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
            GenericHttpMessageConverter genericMessageConverter;
            if (messageConverter instanceof GenericHttpMessageConverter && (genericMessageConverter = (GenericHttpMessageConverter)messageConverter).canRead(bodyType, bodyClass, contentType)) {
                return genericMessageConverter.read(bodyType, bodyClass, this.requestContext);
            }
            if (!messageConverter.canRead(bodyClass, contentType)) continue;
            return (T)messageConverter.read(bodyClass, this.requestContext);
        }
        throw new HttpMediaTypeNotSupportedException(contentType, this.getSupportedMediaTypes(bodyClass), this.method());
    }

    private List<MediaType> getSupportedMediaTypes(Class<?> bodyClass) {
        ArrayList<MediaType> result = new ArrayList<MediaType>(this.messageConverters.size());
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            result.addAll(converter.getSupportedMediaTypes(bodyClass));
        }
        MimeTypeUtils.sortBySpecificity(result);
        return result;
    }

    @Override
    public <T> T bind(Class<T> bindType, Consumer<WebDataBinder> dataBinderCustomizer) throws BindException {
        Assert.notNull(bindType, (String)"BindType is required");
        Assert.notNull(dataBinderCustomizer, (String)"DataBinderCustomizer is required");
        WebDataBinder dataBinder = new WebDataBinder(null);
        dataBinder.setTargetType(ResolvableType.forClass(bindType));
        dataBinderCustomizer.accept(dataBinder);
        RequestContext context = this.exchange();
        dataBinder.construct(context);
        dataBinder.bind(context);
        BindingResult bindingResult = dataBinder.getBindingResult();
        if (bindingResult.hasErrors()) {
            throw new BindException(bindingResult);
        }
        Object result = bindingResult.getTarget();
        if (result != null) {
            return (T)result;
        }
        throw new IllegalStateException("Binding result has neither target nor errors");
    }

    @Override
    @Nullable
    public Object attribute(String name) {
        return this.requestContext.getAttribute(name);
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    @Override
    public Optional<String> param(String name) {
        return Optional.ofNullable(this.requestContext.getParameter(name));
    }

    @Override
    public List<String> params(String name) {
        List paramValues = (List)this.params.get((Object)name);
        if (CollectionUtils.isEmpty((Collection)paramValues)) {
            return Collections.emptyList();
        }
        return paramValues;
    }

    @Override
    public MultiValueMap<String, String> params() {
        return this.params;
    }

    @Override
    public MultiValueMap<String, Multipart> multipartData() throws IOException {
        MultiValueMap<String, Multipart> result = this.parts;
        if (result == null) {
            this.parts = result = this.requestContext.getMultipartRequest().multipartData();
        }
        return result;
    }

    @Override
    public Map<String, String> pathVariables() {
        Object object = this.requestContext.getAttribute(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (object instanceof Map) {
            Map pathVariables = (Map)object;
            return pathVariables;
        }
        return Collections.emptyMap();
    }

    public String toString() {
        return String.format("HTTP %s %s", new Object[]{this.method(), this.path()});
    }

    static Optional<ServerResponse> checkNotModified(RequestContext context, @Nullable Instant lastModified, @Nullable String etag) {
        CheckNotModifiedResponse response;
        long lastModifiedTimestamp = -1L;
        if (lastModified != null && lastModified.isAfter(Instant.EPOCH)) {
            lastModifiedTimestamp = lastModified.toEpochMilli();
        }
        if ((response = new CheckNotModifiedResponse(context)).checkNotModified(etag, lastModifiedTimestamp)) {
            return Optional.of(((ServerResponse.BodyBuilder)ServerResponse.status(response.status).headers(response.headers)).build());
        }
        return Optional.empty();
    }

    static class DefaultRequestHeaders
    implements ServerRequest.Headers {
        private final HttpHeaders httpHeaders;

        public DefaultRequestHeaders(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders.asReadOnly();
        }

        @Override
        public List<MediaType> accept() {
            return this.httpHeaders.getAccept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.httpHeaders.getAcceptCharset();
        }

        @Override
        public List<Locale.LanguageRange> acceptLanguage() {
            return this.httpHeaders.getAcceptLanguage();
        }

        @Override
        public OptionalLong contentLength() {
            long value = this.httpHeaders.getContentLength();
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.httpHeaders.getContentType());
        }

        @Override
        public InetSocketAddress host() {
            return this.httpHeaders.getHost();
        }

        @Override
        public List<HttpRange> range() {
            return this.httpHeaders.getRange();
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.httpHeaders.get(headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.httpHeaders;
        }

        public String toString() {
            return this.httpHeaders.toString();
        }
    }

    static class CheckNotModifiedResponse
    extends RequestContext {
        private int status = 200;
        private final HttpHeaders headers = HttpHeaders.forWritable();
        private final RequestContext context;

        protected CheckNotModifiedResponse(RequestContext context) {
            super(null, null);
            this.context = context;
        }

        @Override
        public HttpHeaders responseHeaders() {
            return this.headers;
        }

        @Override
        public HttpMethod getMethod() {
            return this.context.getMethod();
        }

        @Override
        public String getMethodValue() {
            return this.context.getMethodValue();
        }

        @Override
        @Nullable
        public HttpCookie getCookie(String name) {
            return this.context.getCookie(name);
        }

        @Override
        protected MultiValueMap<String, String> doGetParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MultiValueMap<String, String> getParameters() {
            return this.context.getParameters();
        }

        @Override
        public HttpHeaders requestHeaders() {
            return this.context.requestHeaders();
        }

        @Override
        public <T> T nativeRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStatus(int sc) {
            this.status = sc;
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public void sendError(int sc) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sendError(int sc, @Nullable String msg) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected OutputStream doGetOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getRequestTimeMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScheme() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServerName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getServerPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String doGetRequestURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRequestURL() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String doGetQueryString() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected HttpCookie[] doGetCookies() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String doGetMethod() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRemoteAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getContentLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected InputStream doGetInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected MultipartRequest createMultipartRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AsyncWebRequest createAsyncWebRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected HttpHeaders createRequestHeaders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCommitted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sendRedirect(String location) throws IOException {
        }
    }
}

