/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.Conventions;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.handler.function.AbstractServerResponse;
import infra.web.handler.function.RenderingResponse;
import infra.web.handler.function.ServerResponse;
import infra.web.view.ModelAndView;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

final class DefaultRenderingResponseBuilder
implements RenderingResponse.Builder {
    private final String name;
    private HttpStatusCode status = HttpStatus.OK;
    private final HttpHeaders headers = HttpHeaders.forWritable();
    private final LinkedHashMap<String, Object> model = new LinkedHashMap();
    private final LinkedMultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();

    public DefaultRenderingResponseBuilder(RenderingResponse other) {
        Assert.notNull((Object)other, (String)"RenderingResponse is required");
        this.name = other.name();
        this.status = other.statusCode();
        this.headers.putAll((Map)((Object)other.headers()));
        this.model.putAll(other.model());
    }

    public DefaultRenderingResponseBuilder(String name) {
        Assert.notNull((Object)name, (String)"Name is required");
        this.name = name;
    }

    @Override
    public RenderingResponse.Builder status(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        this.status = status;
        return this;
    }

    @Override
    public RenderingResponse.Builder status(int status) {
        return this.status(HttpStatusCode.valueOf(status));
    }

    @Override
    public RenderingResponse.Builder cookie(HttpCookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie is required");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    @Override
    public RenderingResponse.Builder cookie(String name, String ... values) {
        for (String value : values) {
            this.cookies.add((Object)name, (Object)new HttpCookie(name, value));
        }
        return this;
    }

    @Override
    public RenderingResponse.Builder cookies(Consumer<MultiValueMap<String, HttpCookie>> cookiesConsumer) {
        cookiesConsumer.accept((MultiValueMap<String, HttpCookie>)this.cookies);
        return this;
    }

    @Override
    public RenderingResponse.Builder cookies(@Nullable Collection<HttpCookie> cookies) {
        if (CollectionUtils.isNotEmpty(cookies)) {
            for (HttpCookie cookie : cookies) {
                this.cookies.add((Object)cookie.getName(), (Object)cookie);
            }
        }
        return this;
    }

    @Override
    public RenderingResponse.Builder cookies(@Nullable MultiValueMap<String, HttpCookie> cookies) {
        this.cookies.setAll(cookies);
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttribute(Object attribute) {
        Assert.notNull((Object)attribute, (String)"Attribute is required");
        if (attribute instanceof Collection && ((Collection)attribute).isEmpty()) {
            return this;
        }
        return this.modelAttribute(Conventions.getVariableName((Object)attribute), attribute);
    }

    @Override
    public RenderingResponse.Builder modelAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"Name is required");
        this.model.put(name, value);
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttributes(Object ... attributes) {
        this.modelAttributes(Arrays.asList(attributes));
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttributes(Collection<?> attributes) {
        attributes.forEach(this::modelAttribute);
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttributes(Map<String, ?> attributes) {
        this.model.putAll(attributes);
        return this;
    }

    @Override
    public RenderingResponse.Builder header(String headerName, String ... headerValues) {
        this.headers.setOrRemove(headerName, headerValues);
        return this;
    }

    @Override
    public RenderingResponse.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public RenderingResponse.Builder headers(@Nullable HttpHeaders headers) {
        this.headers.setAll((Map)((Object)headers));
        return this;
    }

    @Override
    public RenderingResponse build() {
        return new DefaultRenderingResponse(this.status, this.headers, (MultiValueMap<String, HttpCookie>)this.cookies, this.name, (Map<String, Object>)this.model);
    }

    private static final class DefaultRenderingResponse
    extends AbstractServerResponse
    implements RenderingResponse {
        private final String name;
        private final Map<String, Object> model;

        public DefaultRenderingResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, String name, Map<String, Object> model) {
            super(statusCode, headers, cookies);
            this.name = name;
            this.model = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(model));
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Map<String, Object> model() {
            return this.model;
        }

        @Override
        protected Object writeToInternal(RequestContext request, ServerResponse.Context context) {
            ModelAndView mav = new ModelAndView(this.name, this.statusCode());
            mav.addAllObjects(this.model);
            return mav;
        }
    }
}

