/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.ParameterizedTypeReference;
import infra.core.ReactiveAdapter;
import infra.core.ReactiveAdapterRegistry;
import infra.core.ReactiveStreams;
import infra.core.io.InputStreamResource;
import infra.core.io.Resource;
import infra.core.io.ResourceRegion;
import infra.http.CacheControl;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRange;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.async.DeferredResult;
import infra.web.handler.function.AbstractServerResponse;
import infra.web.handler.function.DefaultAsyncServerResponse;
import infra.web.handler.function.EntityResponse;
import infra.web.handler.function.ServerResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class DefaultEntityResponseBuilder<T>
implements EntityResponse.Builder<T> {
    private static final Type RESOURCE_REGION_LIST_TYPE = new ParameterizedTypeReference<List<ResourceRegion>>(){}.getType();
    private final T entity;
    private final Type entityType;
    private HttpStatusCode status = HttpStatus.OK;
    private final HttpHeaders headers = HttpHeaders.forWritable();
    private final LinkedMultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();

    public DefaultEntityResponseBuilder(T entity, @Nullable Type entityType) {
        this.entity = entity;
        this.entityType = entityType != null ? entityType : entity.getClass();
    }

    @Override
    public EntityResponse.Builder<T> status(HttpStatusCode status) {
        Assert.notNull((Object)status, (String)"HttpStatusCode is required");
        this.status = status;
        return this;
    }

    @Override
    public EntityResponse.Builder<T> status(int status) {
        return this.status(HttpStatusCode.valueOf(status));
    }

    @Override
    public EntityResponse.Builder<T> cookie(HttpCookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie is required");
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cookie(String name, String ... values) {
        for (String value : values) {
            this.cookies.add((Object)name, (Object)new HttpCookie(name, value));
        }
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cookies(Consumer<MultiValueMap<String, HttpCookie>> cookiesConsumer) {
        cookiesConsumer.accept((MultiValueMap<String, HttpCookie>)this.cookies);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cookies(@Nullable Collection<HttpCookie> cookies) {
        if (CollectionUtils.isNotEmpty(cookies)) {
            for (HttpCookie cookie : cookies) {
                this.cookies.add((Object)cookie.getName(), (Object)cookie);
            }
        }
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cookies(@Nullable MultiValueMap<String, HttpCookie> cookies) {
        this.cookies.setAll(cookies);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> header(String headerName, String ... headerValues) {
        this.headers.setOrRemove(headerName, headerValues);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> headers(@Nullable HttpHeaders headers) {
        this.headers.setAll((Map)((Object)headers));
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> eTag(@Nullable String etag) {
        this.headers.setETag(etag);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> lastModified(ZonedDateTime lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> lastModified(Instant lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cacheControl(CacheControl cacheControl) {
        this.headers.setCacheControl(cacheControl);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public EntityResponse<T> build() {
        ReactiveAdapter adapter;
        T t = this.entity;
        if (t instanceof CompletionStage) {
            CompletionStage completionStage = (CompletionStage)t;
            return new CompletionStageEntityResponse(this.status, this.headers, (MultiValueMap<String, HttpCookie>)this.cookies, completionStage, this.entityType);
        }
        if (ReactiveStreams.isPresent && (adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(this.entity.getClass())) != null) {
            Publisher publisher = adapter.toPublisher(this.entity);
            return new PublisherEntityResponse(this.status, this.headers, (MultiValueMap<String, HttpCookie>)this.cookies, publisher, this.entityType);
        }
        return new DefaultEntityResponse<T>(this.status, this.headers, (MultiValueMap<String, HttpCookie>)this.cookies, this.entity, this.entityType);
    }

    private static class CompletionStageEntityResponse<T>
    extends DefaultEntityResponse<CompletionStage<T>> {
        public CompletionStageEntityResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, CompletionStage<T> entity, Type entityType) {
            super(statusCode, headers, cookies, entity, entityType);
        }

        @Override
        @Nullable
        protected Object writeToInternal(RequestContext request, ServerResponse.Context context) throws Exception {
            DeferredResult<ServerResponse> deferredResult = this.createDeferredResult(request, context);
            DefaultAsyncServerResponse.writeAsync(request, deferredResult);
            return NONE_RETURN_VALUE;
        }

        private DeferredResult<ServerResponse> createDeferredResult(RequestContext request, ServerResponse.Context context) {
            DeferredResult<ServerResponse> result = new DeferredResult<ServerResponse>();
            ((CompletionStage)this.entity()).whenComplete((value, ex) -> {
                if (ex != null) {
                    ServerResponse errorResponse;
                    if (ex instanceof CompletionException && ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    if ((errorResponse = this.errorResponse((Throwable)ex, request)) != null) {
                        result.setResult(errorResponse);
                    } else {
                        result.setErrorResult(ex);
                    }
                } else {
                    try {
                        this.tryWriteEntityWithMessageConverters(value, request, context);
                        result.setResult(null);
                    }
                    catch (Throwable writeException) {
                        result.setErrorResult(writeException);
                    }
                }
            });
            return result;
        }
    }

    private static class PublisherEntityResponse<T>
    extends DefaultEntityResponse<Publisher<T>> {
        public PublisherEntityResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, Publisher<T> entity, Type entityType) {
            super(statusCode, headers, cookies, entity, entityType);
        }

        @Override
        @Nullable
        protected Object writeToInternal(RequestContext request, ServerResponse.Context context) throws Exception {
            DeferredResult deferredResult = new DeferredResult();
            DefaultAsyncServerResponse.writeAsync(request, deferredResult);
            ((Publisher)this.entity()).subscribe((Subscriber)new DeferredResultSubscriber(request, context, deferredResult));
            return NONE_RETURN_VALUE;
        }

        private class DeferredResultSubscriber
        implements Subscriber<T> {
            private final ServerResponse.Context context;
            @Nullable
            private Subscription subscription;
            private final RequestContext request;
            private final DeferredResult<?> deferredResult;

            public DeferredResultSubscriber(RequestContext request, ServerResponse.Context context, DeferredResult<?> deferredResult) {
                this.request = request;
                this.context = context;
                this.deferredResult = deferredResult;
            }

            public void onSubscribe(Subscription subscription) {
                if (this.subscription == null) {
                    this.subscription = subscription;
                    subscription.request(1L);
                } else {
                    subscription.cancel();
                }
            }

            public void onNext(T t) {
                Assert.state((this.subscription != null ? 1 : 0) != 0, (String)"No subscription");
                try {
                    PublisherEntityResponse.this.tryWriteEntityWithMessageConverters(t, this.request, this.context);
                    this.request.getOutputStream().flush();
                    this.subscription.request(1L);
                }
                catch (Throwable ex) {
                    this.subscription.cancel();
                    this.deferredResult.setErrorResult(ex);
                }
            }

            public void onError(Throwable t) {
                try {
                    PublisherEntityResponse.this.handleError(t, this.request, this.context);
                }
                catch (Throwable handlingThrowable) {
                    this.deferredResult.setErrorResult(handlingThrowable);
                }
            }

            public void onComplete() {
                try {
                    this.request.getOutputStream().flush();
                    this.deferredResult.setResult(null);
                }
                catch (IOException ex) {
                    this.deferredResult.setErrorResult(ex);
                }
            }
        }
    }

    private static class DefaultEntityResponse<T>
    extends AbstractServerResponse
    implements EntityResponse<T> {
        private final T entity;
        private final Type entityType;

        public DefaultEntityResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, T entity, Type entityType) {
            super(statusCode, headers, cookies);
            this.entity = entity;
            this.entityType = entityType;
        }

        @Override
        public T entity() {
            return this.entity;
        }

        @Override
        @Nullable
        protected Object writeToInternal(RequestContext request, ServerResponse.Context context) throws Exception {
            this.writeEntityWithMessageConverters(this.entity, request, context);
            return NONE_RETURN_VALUE;
        }

        protected void writeEntityWithMessageConverters(Object entity, RequestContext request, ServerResponse.Context context) throws IOException {
            MediaType contentType = DefaultEntityResponse.getContentType(request);
            Class<?> entityClass = entity.getClass();
            Type entityType = this.entityType;
            if (entityClass != InputStreamResource.class && Resource.class.isAssignableFrom(entityClass)) {
                request.setHeader("Accept-Ranges", "bytes");
                String rangeHeader = request.requestHeaders().getFirst("Range");
                if (rangeHeader != null) {
                    Resource resource = (Resource)entity;
                    try {
                        List<HttpRange> httpRanges = HttpRange.parseRanges(rangeHeader);
                        request.setStatus(HttpStatus.PARTIAL_CONTENT.value());
                        entity = HttpRange.toResourceRegions(httpRanges, resource);
                        entityClass = entity.getClass();
                        entityType = RESOURCE_REGION_LIST_TYPE;
                    }
                    catch (IllegalArgumentException ex) {
                        request.setHeader("Content-Range", "bytes */" + resource.contentLength());
                        request.setStatus(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
                    }
                }
            }
            for (HttpMessageConverter<?> messageConverter : context.messageConverters()) {
                GenericHttpMessageConverter genericMessageConverter;
                if (messageConverter instanceof GenericHttpMessageConverter && (genericMessageConverter = (GenericHttpMessageConverter)messageConverter).canWrite(entityType, entityClass, contentType)) {
                    genericMessageConverter.write(entity, entityType, contentType, request.asHttpOutputMessage());
                    return;
                }
                if (!messageConverter.canWrite(entityClass, contentType)) continue;
                messageConverter.write(entity, contentType, request.asHttpOutputMessage());
                return;
            }
            List<MediaType> producibleMediaTypes = DefaultEntityResponse.producibleMediaTypes(context.messageConverters(), entityClass);
            throw new HttpMediaTypeNotAcceptableException(producibleMediaTypes);
        }

        @Nullable
        private static MediaType getContentType(RequestContext response) {
            try {
                return MediaType.parseMediaType(response.getResponseContentType()).removeQualityValue();
            }
            catch (InvalidMediaTypeException ex) {
                return null;
            }
        }

        protected void tryWriteEntityWithMessageConverters(Object entity, RequestContext request, ServerResponse.Context context) throws Throwable {
            try {
                this.writeEntityWithMessageConverters(entity, request, context);
            }
            catch (IOException ex) {
                this.handleError(ex, request, context);
            }
        }

        private static List<MediaType> producibleMediaTypes(List<HttpMessageConverter<?>> messageConverters, Class<?> entityClass) {
            return messageConverters.stream().filter(messageConverter -> messageConverter.canWrite(entityClass, null)).flatMap(messageConverter -> messageConverter.getSupportedMediaTypes(entityClass).stream()).toList();
        }
    }
}

