/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.async.DeferredResult;
import infra.web.async.WebAsyncManager;
import infra.web.handler.function.AsyncServerResponse;
import infra.web.handler.function.ErrorHandlingServerResponse;
import infra.web.handler.function.ServerResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

final class DefaultAsyncServerResponse
extends ErrorHandlingServerResponse
implements AsyncServerResponse {
    private final CompletableFuture<ServerResponse> futureResponse;
    @Nullable
    private final Duration timeout;

    DefaultAsyncServerResponse(CompletableFuture<ServerResponse> futureResponse, @Nullable Duration timeout) {
        this.futureResponse = futureResponse;
        this.timeout = timeout;
    }

    @Override
    public ServerResponse block() {
        try {
            if (this.timeout != null) {
                return this.futureResponse.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            return this.futureResponse.get();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new IllegalStateException("Failed to get future response", ex);
        }
    }

    @Override
    public HttpStatusCode statusCode() {
        return this.delegate(ServerResponse::statusCode);
    }

    @Override
    public int rawStatusCode() {
        return this.delegate(ServerResponse::rawStatusCode);
    }

    @Override
    public HttpHeaders headers() {
        return this.delegate(ServerResponse::headers);
    }

    @Override
    public MultiValueMap<String, HttpCookie> cookies() {
        return this.delegate(ServerResponse::cookies);
    }

    private <R> R delegate(Function<ServerResponse, R> function) {
        ServerResponse response = this.futureResponse.getNow(null);
        if (response != null) {
            return function.apply(response);
        }
        throw new IllegalStateException("Future ServerResponse has not yet completed");
    }

    @Override
    public Object writeTo(RequestContext request, ServerResponse.Context context) throws Exception {
        DefaultAsyncServerResponse.writeAsync(request, this.createDeferredResult(request));
        return NONE_RETURN_VALUE;
    }

    static void writeAsync(RequestContext request, DeferredResult<?> deferredResult) throws Exception {
        WebAsyncManager asyncManager = request.getAsyncManager();
        asyncManager.startDeferredResultProcessing(deferredResult, new Object[0]);
    }

    private DeferredResult<ServerResponse> createDeferredResult(RequestContext request) {
        DeferredResult<ServerResponse> result = this.timeout != null ? new DeferredResult(this.timeout.toMillis()) : new DeferredResult<ServerResponse>();
        this.futureResponse.whenComplete((value, ex) -> {
            if (ex != null) {
                ServerResponse errorResponse;
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                if ((errorResponse = this.errorResponse((Throwable)ex, request)) != null) {
                    result.setResult(errorResponse);
                } else {
                    result.setErrorResult(ex);
                }
            } else {
                result.setResult((ServerResponse)value);
            }
        });
        return result;
    }
}

