/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.ReactiveAdapter;
import infra.core.ReactiveAdapterRegistry;
import infra.core.ReactiveStreams;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.handler.function.CompletedAsyncServerResponse;
import infra.web.handler.function.DefaultAsyncServerResponse;
import infra.web.handler.function.ServerResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.reactivestreams.Publisher;

public interface AsyncServerResponse
extends ServerResponse {
    public ServerResponse block();

    public static AsyncServerResponse create(Object asyncResponse) {
        return AsyncServerResponse.create(asyncResponse, null);
    }

    public static AsyncServerResponse create(Object asyncResponse, @Nullable Duration timeout) {
        Assert.notNull((Object)asyncResponse, (String)"AsyncResponse is required");
        CompletableFuture<ServerResponse> futureResponse = AsyncServerResponse.toCompletableFuture(asyncResponse);
        if (futureResponse.isDone() && !futureResponse.isCancelled() && !futureResponse.isCompletedExceptionally()) {
            try {
                ServerResponse completedResponse = futureResponse.get();
                return new CompletedAsyncServerResponse(completedResponse);
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return new DefaultAsyncServerResponse(futureResponse, timeout);
    }

    private static CompletableFuture<ServerResponse> toCompletableFuture(Object obj) {
        ReactiveAdapterRegistry registry;
        ReactiveAdapter publisherAdapter;
        if (obj instanceof CompletableFuture) {
            CompletableFuture futureResponse = (CompletableFuture)obj;
            return futureResponse;
        }
        if (ReactiveStreams.isPresent && (publisherAdapter = (registry = ReactiveAdapterRegistry.getSharedInstance()).getAdapter(obj.getClass())) != null) {
            Publisher publisher = publisherAdapter.toPublisher(obj);
            ReactiveAdapter futureAdapter = registry.getAdapter(CompletableFuture.class);
            if (futureAdapter != null) {
                return (CompletableFuture)futureAdapter.fromPublisher(publisher);
            }
        }
        throw new IllegalArgumentException("Asynchronous type not supported: " + obj.getClass());
    }
}

