/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.handler.function.ErrorHandlingServerResponse;
import infra.web.handler.function.ServerResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbstractServerResponse
extends ErrorHandlingServerResponse {
    private static final Set<HttpMethod> SAFE_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD);
    private final HttpStatusCode statusCode;
    private final HttpHeaders headers;
    @Nullable
    private final MultiValueMap<String, HttpCookie> cookies;

    protected AbstractServerResponse(HttpStatusCode statusCode, HttpHeaders headers, @Nullable MultiValueMap<String, HttpCookie> cookies) {
        this.statusCode = statusCode;
        this.headers = headers.asReadOnly();
        this.cookies = cookies;
    }

    @Override
    public final HttpStatusCode statusCode() {
        return this.statusCode;
    }

    @Override
    public int rawStatusCode() {
        return this.statusCode.value();
    }

    @Override
    public final HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, HttpCookie> cookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        return MultiValueMap.empty();
    }

    @Override
    @Nullable
    public Object writeTo(RequestContext request, ServerResponse.Context context) throws Throwable {
        try {
            this.writeStatusAndHeaders(request);
            if (SAFE_METHODS.contains((Object)request.getMethod()) && request.checkNotModified(this.headers().getETag(), this.headers().getLastModified())) {
                return NONE_RETURN_VALUE;
            }
            return this.writeToInternal(request, context);
        }
        catch (Throwable throwable) {
            return this.handleError(throwable, request, context);
        }
    }

    private void writeStatusAndHeaders(RequestContext response) {
        response.setStatus(this.statusCode);
        this.writeHeaders(response);
        this.writeCookies(response);
    }

    private void writeHeaders(RequestContext context) {
        context.mergeToResponse(this.headers);
        if (context.getResponseContentType() == null && this.headers.getFirst("Content-Type") != null) {
            context.setContentType(this.headers.getFirst("Content-Type"));
        }
    }

    private void writeCookies(RequestContext context) {
        if (CollectionUtils.isNotEmpty(this.cookies)) {
            for (Map.Entry entry : this.cookies.entrySet()) {
                for (HttpCookie cookie : (List)entry.getValue()) {
                    context.addCookie(cookie);
                }
            }
        }
    }

    @Nullable
    protected abstract Object writeToInternal(RequestContext var1, ServerResponse.Context var2) throws Throwable;
}

