/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.web.RequestContext;
import infra.web.handler.condition.AbstractRequestCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RequestMethodsRequestCondition
extends AbstractRequestCondition<RequestMethodsRequestCondition> {
    private static final EnumMap<HttpMethod, RequestMethodsRequestCondition> requestMethodConditionCache = new EnumMap(HttpMethod.class);
    private final Set<HttpMethod> methods;

    public RequestMethodsRequestCondition(HttpMethod ... requestMethods) {
        this.methods = ObjectUtils.isEmpty((Object[])requestMethods) ? Collections.emptySet() : new LinkedHashSet<HttpMethod>(Arrays.asList(requestMethods));
    }

    private RequestMethodsRequestCondition(Set<HttpMethod> methods) {
        this.methods = methods;
    }

    public Set<HttpMethod> getMethods() {
        return this.methods;
    }

    @Override
    protected Collection<HttpMethod> getContent() {
        return this.methods;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public RequestMethodsRequestCondition combine(RequestMethodsRequestCondition other) {
        if (this.isEmpty() && other.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        LinkedHashSet<HttpMethod> set = new LinkedHashSet<HttpMethod>(this.methods);
        set.addAll(other.methods);
        return new RequestMethodsRequestCondition(set);
    }

    @Override
    @Nullable
    public RequestMethodsRequestCondition getMatchingCondition(RequestContext request) {
        if (request.isPreFlightRequest()) {
            return this.matchPreFlight(request);
        }
        if (this.getMethods().isEmpty()) {
            if (HttpMethod.OPTIONS == request.getMethod()) {
                return null;
            }
            return this;
        }
        return this.matchRequestMethod(request.getMethod());
    }

    @Nullable
    private RequestMethodsRequestCondition matchPreFlight(RequestContext request) {
        if (this.getMethods().isEmpty()) {
            return this;
        }
        HttpHeaders headers = request.getHeaders();
        HttpMethod expectedMethod = headers.getAccessControlRequestMethod();
        Assert.state((expectedMethod != null ? 1 : 0) != 0, (String)"No Access-Control-Request-Method Header");
        return this.matchRequestMethod(expectedMethod);
    }

    @Nullable
    private RequestMethodsRequestCondition matchRequestMethod(HttpMethod requestMethod) {
        try {
            if (this.getMethods().contains((Object)requestMethod)) {
                return requestMethodConditionCache.get((Object)requestMethod);
            }
            if (requestMethod.equals((Object)HttpMethod.HEAD) && this.getMethods().contains((Object)HttpMethod.GET)) {
                return requestMethodConditionCache.get((Object)HttpMethod.GET);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int compareTo(RequestMethodsRequestCondition other, RequestContext request) {
        if (other.methods.size() != this.methods.size()) {
            return other.methods.size() - this.methods.size();
        }
        if (this.methods.size() == 1) {
            if (this.methods.contains((Object)HttpMethod.HEAD) && other.methods.contains((Object)HttpMethod.GET)) {
                return -1;
            }
            if (this.methods.contains((Object)HttpMethod.GET) && other.methods.contains((Object)HttpMethod.HEAD)) {
                return 1;
            }
        }
        return 0;
    }

    static {
        for (HttpMethod method : HttpMethod.values()) {
            requestMethodConditionCache.put(method, new RequestMethodsRequestCondition(method));
        }
    }
}

