/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.http.MediaType;
import infra.lang.Nullable;
import infra.web.HttpMediaTypeException;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationManager;
import infra.web.handler.condition.AbstractRequestCondition;
import infra.web.handler.condition.MediaTypeExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ProducesRequestCondition
extends AbstractRequestCondition<ProducesRequestCondition> {
    private static final String MEDIA_TYPES_ATTRIBUTE = ProducesRequestCondition.class.getName() + ".MEDIA_TYPES";
    private static final ContentNegotiationManager DEFAULT_CONTENT_NEGOTIATION_MANAGER = new ContentNegotiationManager();
    private static final ProducesRequestCondition EMPTY_CONDITION = new ProducesRequestCondition(new String[0]);
    private static final List<MediaTypeExpression> MEDIA_TYPE_ALL_LIST = Collections.singletonList(new MediaTypeExpression("*/*"));
    @Nullable
    private final ArrayList<MediaTypeExpression> expressions;
    private final ContentNegotiationManager contentNegotiationManager;
    @Nullable
    private MediaType[] producibleMediaTypes;

    public ProducesRequestCondition(String ... produces) {
        this(produces, (String[])null, (ContentNegotiationManager)null);
    }

    public ProducesRequestCondition(String[] produces, @Nullable String[] headers) {
        this(produces, headers, (ContentNegotiationManager)null);
    }

    public ProducesRequestCondition(String[] produces, @Nullable String[] headers, @Nullable ContentNegotiationManager manager) {
        ArrayList<MediaTypeExpression> expressions = MediaTypeExpression.parse("Accept", produces, headers);
        if (expressions != null) {
            Collections.sort(expressions);
        }
        this.expressions = expressions;
        this.contentNegotiationManager = manager != null ? manager : DEFAULT_CONTENT_NEGOTIATION_MANAGER;
    }

    private ProducesRequestCondition(ArrayList<MediaTypeExpression> expressions, ProducesRequestCondition other) {
        this.expressions = expressions;
        this.contentNegotiationManager = other.contentNegotiationManager;
        this.producibleMediaTypes = other.getProducibleMediaTypes();
    }

    public Set<MediaTypeExpression> getExpressions() {
        return this.expressions == null ? Collections.emptySet() : new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public MediaType[] getProducibleMediaTypes() {
        MediaType[] producibleMediaTypes = this.producibleMediaTypes;
        if (producibleMediaTypes == null) {
            producibleMediaTypes = MediaTypeExpression.filterNotNegated(this.expressions).toArray(new MediaType[0]);
            this.producibleMediaTypes = producibleMediaTypes;
        }
        return producibleMediaTypes;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions == null;
    }

    @Override
    protected List<MediaTypeExpression> getContent() {
        return this.expressions == null ? Collections.emptyList() : this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ProducesRequestCondition combine(ProducesRequestCondition other) {
        return other.expressions != null ? other : this;
    }

    @Override
    @Nullable
    public ProducesRequestCondition getMatchingCondition(RequestContext request) {
        List<MediaType> acceptedMediaTypes;
        if (request.isPreFlightRequest()) {
            return EMPTY_CONDITION;
        }
        if (this.expressions == null) {
            return this;
        }
        try {
            acceptedMediaTypes = this.getAcceptedMediaTypes(request);
        }
        catch (HttpMediaTypeException ex) {
            return null;
        }
        ArrayList<MediaTypeExpression> result = this.getMatchingExpressions(acceptedMediaTypes);
        if (result != null) {
            return new ProducesRequestCondition(result, this);
        }
        if (MediaType.ALL.isPresentIn(acceptedMediaTypes)) {
            return EMPTY_CONDITION;
        }
        return null;
    }

    @Nullable
    private ArrayList<MediaTypeExpression> getMatchingExpressions(List<MediaType> acceptedMediaTypes) {
        ArrayList<MediaTypeExpression> expressions = this.expressions;
        if (expressions == null) {
            return null;
        }
        ArrayList<MediaTypeExpression> result = null;
        for (MediaTypeExpression expression : expressions) {
            if (!expression.matchAccept(acceptedMediaTypes)) continue;
            if (result == null) {
                result = new ArrayList<MediaTypeExpression>(expressions.size());
            }
            result.add(expression);
        }
        return result;
    }

    @Override
    public int compareTo(ProducesRequestCondition other, RequestContext request) {
        try {
            List<MediaType> acceptedMediaTypes = this.getAcceptedMediaTypes(request);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                int otherIndex;
                int thisIndex = this.indexOfEqualMediaType(acceptedMediaType);
                int result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfEqualMediaType(acceptedMediaType));
                if (result != 0) {
                    return result;
                }
                thisIndex = this.indexOfIncludedMediaType(acceptedMediaType);
                result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfIncludedMediaType(acceptedMediaType));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            throw new IllegalStateException("Cannot compare without having any requested media types", (Throwable)((Object)ex));
        }
    }

    private List<MediaType> getAcceptedMediaTypes(RequestContext request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> result = (List<MediaType>)request.getAttribute(MEDIA_TYPES_ATTRIBUTE);
        if (result == null) {
            result = this.contentNegotiationManager.resolveMediaTypes(request);
            request.setAttribute(MEDIA_TYPES_ATTRIBUTE, result);
        }
        return result;
    }

    private int indexOfEqualMediaType(MediaType mediaType) {
        List<MediaTypeExpression> expressionsToCompare = this.getExpressionsToCompare();
        for (int i = 0; i < expressionsToCompare.size(); ++i) {
            MediaType currentMediaType = expressionsToCompare.get((int)i).mediaType;
            if (!mediaType.getType().equalsIgnoreCase(currentMediaType.getType()) || !mediaType.getSubtype().equalsIgnoreCase(currentMediaType.getSubtype())) continue;
            return i;
        }
        return -1;
    }

    private int indexOfIncludedMediaType(MediaType mediaType) {
        List<MediaTypeExpression> expressionsToCompare = this.getExpressionsToCompare();
        for (int i = 0; i < expressionsToCompare.size(); ++i) {
            if (!mediaType.includes(expressionsToCompare.get((int)i).mediaType)) continue;
            return i;
        }
        return -1;
    }

    private int compareMatchingMediaTypes(ProducesRequestCondition condition1, int index1, ProducesRequestCondition condition2, int index2) {
        MediaTypeExpression expr2;
        MediaTypeExpression expr1;
        int result = 0;
        if (index1 != index2) {
            result = index2 - index1;
        } else if (index1 != -1 && (result = (expr1 = condition1.getExpressionsToCompare().get(index1)).compareTo(expr2 = condition2.getExpressionsToCompare().get(index2))) == 0) {
            result = expr1.mediaType.compareTo(expr2.mediaType);
        }
        return result;
    }

    private List<MediaTypeExpression> getExpressionsToCompare() {
        return this.expressions == null ? MEDIA_TYPE_ALL_LIST : this.expressions;
    }
}

