/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.http.server.PathContainer;
import infra.lang.Nullable;
import infra.util.ArrayIterator;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.handler.condition.AbstractRequestCondition;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PathPatternParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class PathPatternsRequestCondition
extends AbstractRequestCondition<PathPatternsRequestCondition> {
    private static final Set<String> EMPTY_PATH = Collections.singleton("");
    private static final PathPattern[] EMPTY_PATH_PATTERN = new PathPattern[]{PathPatternParser.defaultInstance.parse("")};
    private static final PathPattern[] ROOT_PATH_PATTERNS = new PathPattern[]{EMPTY_PATH_PATTERN[0], PathPatternParser.defaultInstance.parse("/")};
    private final PathPattern[] patterns;

    public PathPatternsRequestCondition() {
        this(EMPTY_PATH_PATTERN);
    }

    public PathPatternsRequestCondition(PathPatternParser parser, String ... patterns) {
        this(PathPatternsRequestCondition.parse(parser, patterns));
    }

    private static PathPattern[] parse(PathPatternParser parser, String ... patterns) {
        if (patterns.length == 0 || patterns.length == 1 && StringUtils.isBlank((String)patterns[0])) {
            return EMPTY_PATH_PATTERN;
        }
        TreeSet<PathPattern> result = new TreeSet<PathPattern>();
        for (String path : patterns) {
            String pathPattern = StringUtils.prependLeadingSlash((String)path);
            result.add(parser.parse(pathPattern));
        }
        return result.toArray(new PathPattern[0]);
    }

    private PathPatternsRequestCondition(PathPattern[] patterns) {
        this.patterns = patterns;
    }

    public PathPattern[] getPatterns() {
        return this.patterns;
    }

    @Override
    protected Collection<PathPattern> getContent() {
        return Arrays.asList(this.patterns);
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    public PathPattern getFirstPattern() {
        return this.patterns[0];
    }

    public boolean isEmptyPathMapping() {
        return this.patterns == EMPTY_PATH_PATTERN;
    }

    public Set<String> getDirectPaths() {
        if (this.isEmptyPathMapping()) {
            return EMPTY_PATH;
        }
        HashSet<String> result = Collections.emptySet();
        for (PathPattern pattern : this.patterns) {
            if (pattern.hasPatternSyntax()) continue;
            result = result.isEmpty() ? new HashSet<String>(1) : result;
            result.add(pattern.getPatternString());
        }
        return result;
    }

    public Set<String> getPatternValues() {
        return this.isEmptyPathMapping() ? EMPTY_PATH : Arrays.stream(this.patterns).map(PathPattern::getPatternString).collect(Collectors.toSet());
    }

    @Override
    public PathPatternsRequestCondition combine(PathPatternsRequestCondition other) {
        if (this.isEmptyPathMapping() && other.isEmptyPathMapping()) {
            return new PathPatternsRequestCondition(ROOT_PATH_PATTERNS);
        }
        if (other.isEmptyPathMapping()) {
            return this;
        }
        if (this.isEmptyPathMapping()) {
            return other;
        }
        TreeSet<PathPattern> combined = new TreeSet<PathPattern>();
        for (PathPattern pattern1 : this.patterns) {
            for (PathPattern pattern2 : other.patterns) {
                combined.add(pattern1.combine(pattern2));
            }
        }
        return new PathPatternsRequestCondition(combined.toArray(new PathPattern[0]));
    }

    @Override
    @Nullable
    public PathPatternsRequestCondition getMatchingCondition(RequestContext request) {
        PathPattern[] matches = this.getMatchingPatterns(request.getRequestPath());
        return matches != null ? new PathPatternsRequestCondition(matches) : null;
    }

    @Nullable
    private PathPattern[] getMatchingPatterns(PathContainer lookupPath) {
        PathPattern[] pathPatterns = new PathPattern[this.patterns.length];
        int i = 0;
        for (PathPattern pattern : this.patterns) {
            if (!pattern.matches(lookupPath)) continue;
            pathPatterns[i++] = pattern;
        }
        if (i == 0) {
            return null;
        }
        if (i == 1 && this.patterns.length == 1) {
            return pathPatterns;
        }
        PathPattern[] patterns = new PathPattern[i];
        if (i == 1) {
            patterns[0] = pathPatterns[0];
        } else {
            System.arraycopy(pathPatterns, 0, patterns, 0, i);
        }
        return patterns;
    }

    @Override
    public int compareTo(PathPatternsRequestCondition other, RequestContext request) {
        ArrayIterator iterator = new ArrayIterator((Object[])this.patterns);
        ArrayIterator iteratorOther = new ArrayIterator((Object[])other.patterns);
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = PathPattern.SPECIFICITY_COMPARATOR.compare((PathPattern)iterator.next(), (PathPattern)iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

