/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import infra.web.RequestContext;
import infra.web.handler.condition.AbstractRequestCondition;
import infra.web.handler.condition.NameValueExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ParamsRequestCondition
extends AbstractRequestCondition<ParamsRequestCondition> {
    private final Set<ParamExpression> expressions;

    public ParamsRequestCondition(String ... params) {
        this.expressions = ParamsRequestCondition.parseExpressions(params);
    }

    private static Set<ParamExpression> parseExpressions(String ... params) {
        if (ObjectUtils.isEmpty((Object[])params)) {
            return Collections.emptySet();
        }
        LinkedHashSet<ParamExpression> expressions = new LinkedHashSet<ParamExpression>(params.length);
        for (String param : params) {
            expressions.add(new ParamExpression(param));
        }
        return expressions;
    }

    private ParamsRequestCondition(Set<ParamExpression> conditions) {
        this.expressions = conditions;
    }

    public Set<NameValueExpression> getExpressions() {
        return new LinkedHashSet<NameValueExpression>(this.expressions);
    }

    @Override
    protected Collection<ParamExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public ParamsRequestCondition combine(ParamsRequestCondition other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        LinkedHashSet<ParamExpression> set = new LinkedHashSet<ParamExpression>(this.expressions);
        set.addAll(other.expressions);
        return new ParamsRequestCondition(set);
    }

    @Override
    @Nullable
    public ParamsRequestCondition getMatchingCondition(RequestContext request) {
        for (ParamExpression expression : this.expressions) {
            if (expression.match(request)) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(ParamsRequestCondition other, RequestContext request) {
        int result = other.expressions.size() - this.expressions.size();
        if (result != 0) {
            return result;
        }
        return ParamsRequestCondition.getValueMatchCount(other.expressions) - ParamsRequestCondition.getValueMatchCount(this.expressions);
    }

    private static int getValueMatchCount(Set<ParamExpression> expressions) {
        int count = 0;
        for (ParamExpression e : expressions) {
            if (e.value == null || e.negated) continue;
            ++count;
        }
        return count;
    }

    static class ParamExpression
    extends NameValueExpression {
        final HashSet<String> namesToMatch;

        ParamExpression(String expression) {
            this(expression, new HashSet<String>());
        }

        ParamExpression(String expression, HashSet<String> namesToMatch) {
            super(expression);
            this.namesToMatch = namesToMatch;
            this.namesToMatch.add(this.name);
        }

        @Override
        protected boolean isCaseSensitiveName() {
            return true;
        }

        @Override
        protected boolean matchName(RequestContext request) {
            MultiValueMap<String, String> parameters = request.getParameters();
            for (String current : this.namesToMatch) {
                if (parameters.get((Object)current) == null) continue;
                return true;
            }
            return parameters.containsKey((Object)this.name);
        }

        @Override
        protected boolean matchValue(RequestContext request) {
            return ObjectUtils.nullSafeEquals((Object)this.value, (Object)request.getParameter(this.name));
        }
    }
}

