/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.web.RequestContext;
import java.util.Locale;

public abstract class NameValueExpression {
    public final String name;
    @Nullable
    public final String value;
    public final boolean negated;

    NameValueExpression(String expression) {
        int separator = expression.indexOf(61);
        if (separator == -1) {
            this.negated = expression.charAt(0) == '!';
            this.name = this.negated ? expression.substring(1) : expression;
            this.value = null;
        } else {
            this.negated = separator > 0 && expression.charAt(separator - 1) == '!';
            this.name = this.negated ? expression.substring(0, separator - 1) : expression.substring(0, separator);
            this.value = expression.substring(separator + 1);
        }
    }

    public final boolean match(RequestContext request) {
        boolean isMatch = this.value != null ? this.matchValue(request) : this.matchName(request);
        return this.negated != isMatch;
    }

    protected abstract boolean isCaseSensitiveName();

    protected abstract boolean matchName(RequestContext var1);

    protected abstract boolean matchValue(RequestContext var1);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NameValueExpression that = (NameValueExpression)other;
        return (this.isCaseSensitiveName() ? this.name.equals(that.name) : this.name.equalsIgnoreCase(that.name)) && ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value) && this.negated == that.negated;
    }

    public int hashCode() {
        int result = this.isCaseSensitiveName() ? this.name.hashCode() : this.name.toLowerCase(Locale.ROOT).hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.negated ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.value != null) {
            builder.append(this.name);
            if (this.negated) {
                builder.append('!');
            }
            builder.append('=');
            builder.append(this.value);
        } else {
            if (this.negated) {
                builder.append('!');
            }
            builder.append(this.name);
        }
        return builder.toString();
    }
}

