/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.handler.condition.HeadersRequestCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MediaTypeExpression
implements Comparable<MediaTypeExpression> {
    public final MediaType mediaType;
    public final boolean isNegated;

    MediaTypeExpression(String expression) {
        if (expression.charAt(0) == '!') {
            this.isNegated = true;
            expression = expression.substring(1);
        } else {
            this.isNegated = false;
        }
        this.mediaType = MediaType.parseMediaType(expression);
    }

    MediaTypeExpression(MediaType mediaType, boolean negated) {
        this.mediaType = mediaType;
        this.isNegated = negated;
    }

    public boolean matchContentType(MediaType contentType) {
        boolean match = this.mediaType.includes(contentType) && this.matchParameters(contentType);
        return !this.isNegated == match;
    }

    public boolean matchAccept(List<MediaType> acceptedMediaTypes) {
        boolean match = this.matchMediaType(acceptedMediaTypes);
        return !this.isNegated == match;
    }

    private boolean matchMediaType(List<MediaType> acceptedMediaTypes) {
        for (MediaType acceptedMediaType : acceptedMediaTypes) {
            if (!this.mediaType.isCompatibleWith(acceptedMediaType) || !this.matchParameters(acceptedMediaType)) continue;
            return true;
        }
        return false;
    }

    private boolean matchParameters(MediaType contentType) {
        for (Map.Entry entry : this.mediaType.getParameters().entrySet()) {
            String value;
            if (!StringUtils.hasText((String)((String)entry.getValue())) || !StringUtils.hasText((String)(value = contentType.getParameter((String)entry.getKey()))) || ((String)entry.getValue()).equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(MediaTypeExpression other) {
        MediaType mediaType1 = this.mediaType;
        MediaType mediaType2 = other.mediaType;
        if (mediaType1.isMoreSpecific(mediaType2)) {
            return -1;
        }
        if (mediaType1.isLessSpecific(mediaType2)) {
            return 1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MediaTypeExpression otherExpr = (MediaTypeExpression)other;
        return this.mediaType.equals(otherExpr.mediaType) && this.isNegated == otherExpr.isNegated;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String toString() {
        if (this.isNegated) {
            return "!" + this.mediaType.toString();
        }
        return this.mediaType.toString();
    }

    @Nullable
    static ArrayList<MediaTypeExpression> parse(String exprHeader, String[] expressions, @Nullable String[] headers) {
        LinkedHashSet<MediaTypeExpression> result = null;
        if (ObjectUtils.isNotEmpty((Object[])headers)) {
            for (String header : headers) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!exprHeader.equalsIgnoreCase(expr.name) || expr.value == null) continue;
                if (result == null) {
                    result = new LinkedHashSet();
                }
                for (MediaType mediaType : MediaType.parseMediaTypes(expr.value)) {
                    result.add(new MediaTypeExpression(mediaType, expr.negated));
                }
            }
        }
        if (ObjectUtils.isNotEmpty((Object[])expressions)) {
            for (String produce : expressions) {
                if (result == null) {
                    result = new LinkedHashSet<MediaTypeExpression>();
                }
                result.add(new MediaTypeExpression(produce));
            }
        }
        return CollectionUtils.isNotEmpty(result) ? new ArrayList(result) : null;
    }

    static Set<MediaType> filterNotNegated(@Nullable ArrayList<MediaTypeExpression> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (MediaTypeExpression expression : expressions) {
            if (expression.isNegated) continue;
            result.add(expression.mediaType);
        }
        return result;
    }
}

