/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.web.RequestContext;
import infra.web.handler.condition.AbstractRequestCondition;
import infra.web.handler.condition.NameValueExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class HeadersRequestCondition
extends AbstractRequestCondition<HeadersRequestCondition> {
    private static final HeadersRequestCondition PRE_FLIGHT_MATCH = new HeadersRequestCondition(new String[0]);
    @Nullable
    private final LinkedHashSet<HeaderExpression> expressions;

    public HeadersRequestCondition(String ... headers) {
        this.expressions = HeadersRequestCondition.parseExpressions(headers);
    }

    @Nullable
    private static LinkedHashSet<HeaderExpression> parseExpressions(String ... headers) {
        LinkedHashSet<HeaderExpression> result = null;
        if (ObjectUtils.isNotEmpty((Object[])headers)) {
            for (String header : headers) {
                HeaderExpression expr = new HeaderExpression(header);
                if ("Accept".equalsIgnoreCase(expr.name) || "Content-Type".equalsIgnoreCase(expr.name)) continue;
                if (result == null) {
                    result = new LinkedHashSet<HeaderExpression>(headers.length);
                }
                result.add(expr);
            }
        }
        return result;
    }

    private HeadersRequestCondition(LinkedHashSet<HeaderExpression> conditions) {
        this.expressions = conditions;
    }

    public Set<NameValueExpression> getExpressions() {
        return this.expressions == null ? Collections.emptySet() : new LinkedHashSet<HeaderExpression>(this.expressions);
    }

    @Override
    protected Collection<HeaderExpression> getContent() {
        return this.expressions == null ? Collections.emptySet() : this.expressions;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions == null;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public HeadersRequestCondition combine(HeadersRequestCondition other) {
        LinkedHashSet<HeaderExpression> expressions = this.expressions;
        LinkedHashSet<HeaderExpression> otherExpressions = other.expressions;
        if (expressions == null && otherExpressions == null) {
            return this;
        }
        if (otherExpressions == null) {
            return this;
        }
        if (expressions == null) {
            return other;
        }
        LinkedHashSet<HeaderExpression> set = new LinkedHashSet<HeaderExpression>(expressions);
        set.addAll(otherExpressions);
        return new HeadersRequestCondition(set);
    }

    @Override
    @Nullable
    public HeadersRequestCondition getMatchingCondition(RequestContext request) {
        if (request.isPreFlightRequest()) {
            return PRE_FLIGHT_MATCH;
        }
        LinkedHashSet<HeaderExpression> expressions = this.expressions;
        if (expressions != null) {
            for (HeaderExpression expression : expressions) {
                if (expression.match(request)) continue;
                return null;
            }
        }
        return this;
    }

    @Override
    public int compareTo(HeadersRequestCondition other, RequestContext request) {
        LinkedHashSet<HeaderExpression> expressions;
        LinkedHashSet<HeaderExpression> otherExpressions = other.expressions;
        int result = (otherExpressions == null ? 0 : otherExpressions.size()) - ((expressions = this.expressions) == null ? 0 : expressions.size());
        if (result != 0) {
            return result;
        }
        return this.getValueMatchCount(otherExpressions) - this.getValueMatchCount(expressions);
    }

    private int getValueMatchCount(@Nullable LinkedHashSet<HeaderExpression> expressions) {
        if (expressions == null) {
            return 0;
        }
        int count = 0;
        for (HeaderExpression e : expressions) {
            if (e.value == null || e.negated) continue;
            ++count;
        }
        return count;
    }

    static class HeaderExpression
    extends NameValueExpression {
        HeaderExpression(String expression) {
            super(expression);
        }

        @Override
        protected boolean isCaseSensitiveName() {
            return false;
        }

        @Override
        protected boolean matchName(RequestContext request) {
            return request.requestHeaders().getFirst(this.name) != null;
        }

        @Override
        protected boolean matchValue(RequestContext request) {
            return ObjectUtils.nullSafeEquals((Object)this.value, (Object)request.requestHeaders().getFirst(this.name));
        }
    }
}

