/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.handler.condition.AbstractRequestCondition;
import infra.web.handler.condition.MediaTypeExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ConsumesRequestCondition
extends AbstractRequestCondition<ConsumesRequestCondition> {
    private static final ConsumesRequestCondition EMPTY_CONDITION = new ConsumesRequestCondition(new String[0]);
    @Nullable
    private final ArrayList<MediaTypeExpression> expressions;
    private boolean bodyRequired = true;
    @Nullable
    private Set<MediaType> consumableMediaTypes;

    public ConsumesRequestCondition(String ... consumes) {
        this(consumes, (String[])null);
    }

    public ConsumesRequestCondition(String[] consumes, @Nullable String[] headers) {
        ArrayList<MediaTypeExpression> expressions = MediaTypeExpression.parse("Content-Type", consumes, headers);
        if (expressions != null) {
            Collections.sort(expressions);
        }
        this.expressions = expressions;
    }

    private ConsumesRequestCondition(@Nullable ArrayList<MediaTypeExpression> expressions) {
        this.expressions = expressions;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return this.expressions == null ? Collections.emptySet() : new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getConsumableMediaTypes() {
        Set<MediaType> consumableMediaTypes = this.consumableMediaTypes;
        if (consumableMediaTypes == null) {
            this.consumableMediaTypes = consumableMediaTypes = MediaTypeExpression.filterNotNegated(this.expressions);
        }
        return consumableMediaTypes;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions == null;
    }

    @Override
    protected Collection<MediaTypeExpression> getContent() {
        return this.expressions == null ? Collections.emptySet() : this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    public void setBodyRequired(boolean bodyRequired) {
        this.bodyRequired = bodyRequired;
    }

    public boolean isBodyRequired() {
        return this.bodyRequired;
    }

    @Override
    public ConsumesRequestCondition combine(ConsumesRequestCondition other) {
        return other.expressions != null ? other : this;
    }

    @Override
    @Nullable
    public ConsumesRequestCondition getMatchingCondition(RequestContext request) {
        MediaType contentType;
        if (request.isPreFlightRequest()) {
            return EMPTY_CONDITION;
        }
        if (this.isEmpty()) {
            return this;
        }
        if (!ConsumesRequestCondition.hasBody(request) && !this.bodyRequired) {
            return EMPTY_CONDITION;
        }
        try {
            String contentType1 = request.getContentType();
            contentType = StringUtils.isNotEmpty((CharSequence)contentType1) ? MediaType.parseMediaType(contentType1) : MediaType.APPLICATION_OCTET_STREAM;
        }
        catch (InvalidMediaTypeException ex) {
            return null;
        }
        ArrayList<MediaTypeExpression> result = this.getMatchingExpressions(contentType);
        if (result != null) {
            return new ConsumesRequestCondition(result);
        }
        return null;
    }

    private static boolean hasBody(RequestContext request) {
        String transferEncoding = request.requestHeaders().getFirst("Transfer-Encoding");
        return StringUtils.hasText((String)transferEncoding) || request.getContentLength() > 0L;
    }

    @Nullable
    private ArrayList<MediaTypeExpression> getMatchingExpressions(MediaType contentType) {
        ArrayList<MediaTypeExpression> expressions = this.expressions;
        if (expressions == null) {
            return null;
        }
        ArrayList<MediaTypeExpression> result = null;
        for (MediaTypeExpression expression : expressions) {
            if (!expression.matchContentType(contentType)) continue;
            if (result == null) {
                result = new ArrayList<MediaTypeExpression>(expressions.size());
            }
            result.add(expression);
        }
        return result;
    }

    @Override
    public int compareTo(ConsumesRequestCondition other, RequestContext request) {
        ArrayList<MediaTypeExpression> expressions = this.expressions;
        ArrayList<MediaTypeExpression> otherExpressions = other.expressions;
        if (expressions == null && otherExpressions == null) {
            return 0;
        }
        if (expressions == null) {
            return 1;
        }
        if (otherExpressions == null) {
            return -1;
        }
        return expressions.get(0).compareTo(otherExpressions.get(0));
    }
}

