/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.condition;

import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.web.RequestContext;
import infra.web.handler.condition.AbstractRequestCondition;
import infra.web.handler.condition.RequestCondition;
import infra.web.handler.condition.RequestConditionHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompositeRequestCondition
extends AbstractRequestCondition<CompositeRequestCondition> {
    private final RequestConditionHolder[] requestConditions;

    public CompositeRequestCondition(RequestCondition<?> ... requestConditions) {
        this.requestConditions = this.wrap(requestConditions);
    }

    private CompositeRequestCondition(RequestConditionHolder[] requestConditions) {
        this.requestConditions = requestConditions;
    }

    private RequestConditionHolder[] wrap(RequestCondition<?> ... rawConditions) {
        RequestConditionHolder[] wrappedConditions = new RequestConditionHolder[rawConditions.length];
        for (int i = 0; i < rawConditions.length; ++i) {
            wrappedConditions[i] = new RequestConditionHolder(rawConditions[i]);
        }
        return wrappedConditions;
    }

    @Override
    public boolean isEmpty() {
        return ObjectUtils.isEmpty((Object[])this.requestConditions);
    }

    public List<RequestCondition<?>> getConditions() {
        ArrayList result = new ArrayList();
        for (RequestConditionHolder holder : this.requestConditions) {
            result.add(holder.getCondition());
        }
        return result;
    }

    @Override
    protected Collection<?> getContent() {
        return !this.isEmpty() ? this.getConditions() : Collections.emptyList();
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    private int getLength() {
        return this.requestConditions.length;
    }

    @Override
    public CompositeRequestCondition combine(CompositeRequestCondition other) {
        if (this.isEmpty() && other.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        this.assertNumberOfConditions(other);
        int length = this.getLength();
        RequestConditionHolder[] otherConditions = other.requestConditions;
        RequestConditionHolder[] requestConditions = this.requestConditions;
        RequestConditionHolder[] combinedConditions = new RequestConditionHolder[length];
        for (int i = 0; i < length; ++i) {
            combinedConditions[i] = requestConditions[i].combine(otherConditions[i]);
        }
        return new CompositeRequestCondition(combinedConditions);
    }

    private void assertNumberOfConditions(CompositeRequestCondition other) {
        if (this.getLength() != other.getLength()) {
            throw new IllegalArgumentException("Cannot combine CompositeRequestConditions with a different number of conditions. %s and  %s".formatted(ObjectUtils.nullSafeToString((Object[])this.requestConditions), ObjectUtils.nullSafeToString((Object[])other.requestConditions)));
        }
    }

    @Override
    @Nullable
    public CompositeRequestCondition getMatchingCondition(RequestContext request) {
        if (this.isEmpty()) {
            return this;
        }
        int length = this.getLength();
        RequestConditionHolder[] requestConditions = this.requestConditions;
        RequestConditionHolder[] matchingConditions = new RequestConditionHolder[length];
        for (int i = 0; i < length; ++i) {
            matchingConditions[i] = requestConditions[i].getMatchingCondition(request);
            if (matchingConditions[i] != null) continue;
            return null;
        }
        return new CompositeRequestCondition(matchingConditions);
    }

    @Override
    public int compareTo(CompositeRequestCondition other, RequestContext request) {
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return 1;
        }
        if (other.isEmpty()) {
            return -1;
        }
        this.assertNumberOfConditions(other);
        RequestConditionHolder[] otherConditions = other.requestConditions;
        RequestConditionHolder[] requestConditions = this.requestConditions;
        for (int i = 0; i < this.getLength(); ++i) {
            int result = requestConditions[i].compareTo(otherConditions[i], request);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

