/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.handler.AbstractHandlerExceptionHandler;
import infra.web.view.ModelAndView;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SimpleMappingExceptionHandler
extends AbstractHandlerExceptionHandler {
    public static final String DEFAULT_EXCEPTION_ATTRIBUTE = "exception";
    @Nullable
    private Properties exceptionMappings;
    @Nullable
    private Class<?>[] excludedExceptions;
    @Nullable
    private String defaultErrorView;
    @Nullable
    private Integer defaultStatusCode;
    private final HashMap<String, Integer> statusCodes = new HashMap();
    @Nullable
    private String exceptionAttribute = "exception";

    public void setExceptionMappings(@Nullable Properties mappings) {
        this.exceptionMappings = mappings;
    }

    public void setExcludedExceptions(Class<?> ... excludedExceptions) {
        this.excludedExceptions = excludedExceptions;
    }

    public void setDefaultErrorView(@Nullable String defaultErrorView) {
        this.defaultErrorView = defaultErrorView;
    }

    public void setStatusCodes(Properties statusCodes) {
        for (String viewName : statusCodes.stringPropertyNames()) {
            Integer statusCode = Integer.valueOf(statusCodes.getProperty(viewName));
            this.statusCodes.put(viewName, statusCode);
        }
    }

    public void addStatusCode(String viewName, int statusCode) {
        this.statusCodes.put(viewName, statusCode);
    }

    public Map<String, Integer> getStatusCodesAsMap() {
        return this.statusCodes;
    }

    public void setDefaultStatusCode(int defaultStatusCode) {
        this.defaultStatusCode = defaultStatusCode;
    }

    public void setExceptionAttribute(@Nullable String exceptionAttribute) {
        this.exceptionAttribute = exceptionAttribute;
    }

    @Override
    @Nullable
    protected ModelAndView handleInternal(RequestContext request, @Nullable Object handler, Throwable ex) {
        String viewName = this.determineViewName(ex, request);
        if (viewName != null) {
            Integer statusCode = this.determineStatusCode(request, viewName);
            if (statusCode != null) {
                this.applyStatusCodeIfPossible(request, statusCode);
            }
            return this.getModelAndView(viewName, ex, request);
        }
        return null;
    }

    @Nullable
    protected String determineViewName(Throwable ex, RequestContext request) {
        String viewName = null;
        if (this.excludedExceptions != null) {
            for (Class<?> excludedEx : this.excludedExceptions) {
                if (!excludedEx.equals(ex.getClass())) continue;
                return null;
            }
        }
        if (this.exceptionMappings != null) {
            viewName = this.findMatchingViewName(this.exceptionMappings, ex);
        }
        if (viewName == null && this.defaultErrorView != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolving to default view '{}'", (Object)this.defaultErrorView);
            }
            viewName = this.defaultErrorView;
        }
        return viewName;
    }

    @Nullable
    protected String findMatchingViewName(Properties exceptionMappings, Throwable ex) {
        String viewName = null;
        String dominantMapping = null;
        int deepest = Integer.MAX_VALUE;
        Enumeration<?> names = exceptionMappings.propertyNames();
        while (names.hasMoreElements()) {
            String exceptionMapping = (String)names.nextElement();
            int depth = this.getDepth(exceptionMapping, ex);
            if (depth < 0 || depth >= deepest && (depth != deepest || dominantMapping == null || exceptionMapping.length() <= dominantMapping.length())) continue;
            deepest = depth;
            dominantMapping = exceptionMapping;
            viewName = exceptionMappings.getProperty(exceptionMapping);
        }
        if (viewName != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving to view '{}' based on mapping [{}]", viewName, dominantMapping);
        }
        return viewName;
    }

    protected int getDepth(String exceptionMapping, Throwable ex) {
        return this.getDepth(exceptionMapping, ex.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class<?> exceptionClass, int depth) {
        if (exceptionClass.getName().contains(exceptionMapping)) {
            return depth;
        }
        if (exceptionClass == Throwable.class) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }

    @Nullable
    protected Integer determineStatusCode(RequestContext request, String viewName) {
        if (this.statusCodes.containsKey(viewName)) {
            return this.statusCodes.get(viewName);
        }
        return this.defaultStatusCode;
    }

    protected void applyStatusCodeIfPossible(RequestContext request, int statusCode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Applying HTTP status {}", (Object)statusCode);
        }
        request.setStatus(statusCode);
    }

    protected ModelAndView getModelAndView(String viewName, Throwable ex, RequestContext request) {
        return this.getModelAndView(viewName, ex);
    }

    protected ModelAndView getModelAndView(String viewName, Throwable ex) {
        ModelAndView mv = new ModelAndView(viewName);
        if (this.exceptionAttribute != null) {
            mv.addObject(this.exceptionAttribute, ex);
        }
        return mv;
    }
}

