/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.beans.ConversionNotSupportedException;
import infra.beans.TypeMismatchException;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Nullable;
import infra.validation.BindException;
import infra.web.ErrorResponse;
import infra.web.HandlerExceptionHandler;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.HttpMediaTypeNotSupportedException;
import infra.web.HttpRequestMethodNotSupportedException;
import infra.web.NotFoundHandler;
import infra.web.RequestContext;
import infra.web.async.AsyncRequestTimeoutException;
import infra.web.bind.MethodArgumentNotValidException;
import infra.web.bind.MissingPathVariableException;
import infra.web.bind.MissingRequestParameterException;
import infra.web.bind.RequestBindingException;
import infra.web.bind.resolver.MissingRequestPartException;
import infra.web.handler.AbstractHandlerExceptionHandler;
import infra.web.handler.HandlerNotFoundException;
import infra.web.util.DisconnectedClientHelper;
import infra.web.util.WebUtils;
import java.io.IOException;

public class SimpleHandlerExceptionHandler
extends AbstractHandlerExceptionHandler
implements HandlerExceptionHandler {
    public SimpleHandlerExceptionHandler() {
        this.setOrder(Integer.MAX_VALUE);
        this.setWarnLogCategory(this.getClass().getName());
    }

    @Override
    @Nullable
    protected Object handleInternal(RequestContext request, @Nullable Object handler, Throwable ex) {
        try {
            if (ex instanceof ErrorResponse) {
                Object view = null;
                if (ex instanceof HttpRequestMethodNotSupportedException) {
                    view = this.handleHttpRequestMethodNotSupported((HttpRequestMethodNotSupportedException)((Object)ex), request, handler);
                } else if (ex instanceof HttpMediaTypeNotSupportedException) {
                    view = this.handleHttpMediaTypeNotSupported((HttpMediaTypeNotSupportedException)((Object)ex), request, handler);
                } else if (ex instanceof HttpMediaTypeNotAcceptableException) {
                    view = this.handleHttpMediaTypeNotAcceptable((HttpMediaTypeNotAcceptableException)((Object)ex), request, handler);
                } else if (ex instanceof MissingPathVariableException) {
                    view = this.handleMissingPathVariable((MissingPathVariableException)((Object)ex), request, handler);
                } else if (ex instanceof MissingRequestParameterException) {
                    view = this.handleMissingRequestParameter((MissingRequestParameterException)((Object)ex), request, handler);
                } else if (ex instanceof MissingRequestPartException) {
                    view = this.handleMissingRequestPartException((MissingRequestPartException)((Object)ex), request, handler);
                } else if (ex instanceof RequestBindingException) {
                    view = this.handleRequestBindingException((RequestBindingException)((Object)ex), request, handler);
                } else if (ex instanceof MethodArgumentNotValidException) {
                    view = this.handleMethodArgumentNotValidException((MethodArgumentNotValidException)((Object)ex), request, handler);
                } else if (ex instanceof HandlerNotFoundException) {
                    view = this.handleHandlerNotFoundException((HandlerNotFoundException)((Object)ex), request, handler);
                } else if (ex instanceof AsyncRequestTimeoutException) {
                    view = this.handleAsyncRequestTimeoutException((AsyncRequestTimeoutException)ex, request, handler);
                } else if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
                    return this.handleDisconnectedClientException(ex, request, handler);
                }
                if (view == null) {
                    return this.handleErrorResponse((ErrorResponse)((Object)ex), request, handler);
                }
                return view;
            }
            if (ex instanceof ConversionNotSupportedException) {
                return this.handleConversionNotSupported((ConversionNotSupportedException)ex, request, handler);
            }
            if (ex instanceof TypeMismatchException) {
                return this.handleTypeMismatch((TypeMismatchException)ex, request, handler);
            }
            if (ex instanceof HttpMessageNotReadableException) {
                return this.handleHttpMessageNotReadable((HttpMessageNotReadableException)((Object)ex), request, handler);
            }
            if (ex instanceof HttpMessageNotWritableException) {
                return this.handleHttpMessageNotWritable((HttpMessageNotWritableException)((Object)ex), request, handler);
            }
            if (ex instanceof BindException) {
                return this.handleBindException((BindException)ex, request, handler);
            }
        }
        catch (Exception handlerEx) {
            this.logResultedInException(ex, handlerEx);
        }
        return null;
    }

    @Nullable
    protected Object handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleMissingPathVariable(MissingPathVariableException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleMissingRequestParameter(MissingRequestParameterException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleMissingRequestPartException(MissingRequestPartException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleRequestBindingException(RequestBindingException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected Object handleHandlerNotFoundException(HandlerNotFoundException ex, RequestContext request, @Nullable Object handler) throws IOException {
        NotFoundHandler.pageNotFoundLogger.warn(ex.getMessage());
        return null;
    }

    @Nullable
    protected Object handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, RequestContext request, @Nullable Object handler) throws IOException {
        return null;
    }

    protected Object handleDisconnectedClientException(Throwable ex, RequestContext request, @Nullable Object handler) {
        return NONE_RETURN_VALUE;
    }

    protected Object handleErrorResponse(ErrorResponse errorResponse, RequestContext response, @Nullable Object handler) throws IOException {
        if (!response.isCommitted()) {
            HttpHeaders headers = errorResponse.getHeaders();
            response.mergeToResponse(headers);
            String message = errorResponse.getBody().getDetail();
            response.sendError(errorResponse.getStatusCode(), message);
        } else {
            this.logger.warn("Ignoring exception, response committed already: {}", (Object)errorResponse);
        }
        return NONE_RETURN_VALUE;
    }

    protected Object handleConversionNotSupported(ConversionNotSupportedException ex, RequestContext request, @Nullable Object handler) throws IOException {
        this.sendServerError((Exception)ex, request);
        return NONE_RETURN_VALUE;
    }

    protected Object handleTypeMismatch(TypeMismatchException ex, RequestContext request, @Nullable Object handler) throws IOException {
        request.sendError(HttpStatus.BAD_REQUEST);
        return NONE_RETURN_VALUE;
    }

    protected Object handleHttpMessageNotReadable(HttpMessageNotReadableException ex, RequestContext request, @Nullable Object handler) throws IOException {
        request.sendError(HttpStatus.BAD_REQUEST);
        return NONE_RETURN_VALUE;
    }

    protected Object handleHttpMessageNotWritable(HttpMessageNotWritableException ex, RequestContext request, @Nullable Object handler) throws IOException {
        this.sendServerError((Exception)((Object)ex), request);
        return NONE_RETURN_VALUE;
    }

    protected Object handleBindException(BindException ex, RequestContext request, @Nullable Object handler) throws IOException {
        request.sendError(HttpStatus.BAD_REQUEST);
        return NONE_RETURN_VALUE;
    }

    protected void sendServerError(Exception ex, RequestContext request) throws IOException {
        request.setAttribute(WebUtils.ERROR_EXCEPTION_ATTRIBUTE, ex);
        request.sendError(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

