/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.core.ArraySizeTrimmer;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.RequestContext;
import infra.web.ReturnValueHandler;
import infra.web.handler.ReturnValueHandlerNotFoundException;
import java.util.List;

public class SelectableReturnValueHandler
implements ReturnValueHandler,
ArraySizeTrimmer {
    private final List<ReturnValueHandler> internalHandlers;

    public SelectableReturnValueHandler(List<ReturnValueHandler> internalHandlers) {
        Assert.notNull(internalHandlers, (String)"internalHandlers is required");
        this.internalHandlers = internalHandlers;
    }

    @Override
    public boolean supportsHandler(Object handler) {
        return this.selectHandler(handler, NONE_RETURN_VALUE) != null;
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return this.selectHandler(null, returnValue) != null;
    }

    @Nullable
    public final ReturnValueHandler selectHandler(@Nullable Object handler, @Nullable Object returnValue) {
        return ReturnValueHandler.select(this.internalHandlers, handler, returnValue);
    }

    @Override
    public void handleReturnValue(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        if (this.handleSelectively(context, handler, returnValue) == null) {
            throw new ReturnValueHandlerNotFoundException(returnValue, handler);
        }
    }

    @Nullable
    public final ReturnValueHandler handleSelectively(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        ReturnValueHandler selected = this.selectHandler(handler, returnValue);
        if (selected != null && selected != this) {
            selected.handleReturnValue(context, handler, returnValue);
            return selected;
        }
        return null;
    }

    public List<ReturnValueHandler> getInternalHandlers() {
        return this.internalHandlers;
    }

    public void trimToSize() {
        CollectionUtils.trimToSize(this.internalHandlers);
    }
}

