/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.beans.factory.BeanFactory;
import infra.context.support.ApplicationObjectSupport;
import infra.core.ArraySizeTrimmer;
import infra.core.ReactiveAdapterRegistry;
import infra.core.style.ToStringBuilder;
import infra.core.task.AsyncTaskExecutor;
import infra.core.task.TaskExecutor;
import infra.http.converter.AllEncompassingFormHttpMessageConverter;
import infra.http.converter.ByteArrayHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.ErrorResponse;
import infra.web.RedirectModelManager;
import infra.web.RequestContext;
import infra.web.ReturnValueHandler;
import infra.web.accept.ContentNegotiationManager;
import infra.web.bind.resolver.HttpEntityMethodProcessor;
import infra.web.bind.resolver.RequestResponseBodyMethodProcessor;
import infra.web.handler.ReturnValueHandlerNotFoundException;
import infra.web.handler.SelectableReturnValueHandler;
import infra.web.handler.method.ModelAttributeMethodProcessor;
import infra.web.handler.method.ResponseBodyEmitterReturnValueHandler;
import infra.web.handler.result.AsyncTaskMethodReturnValueHandler;
import infra.web.handler.result.CallableMethodReturnValueHandler;
import infra.web.handler.result.DeferredResultReturnValueHandler;
import infra.web.handler.result.HttpHeadersReturnValueHandler;
import infra.web.handler.result.HttpStatusReturnValueHandler;
import infra.web.handler.result.ObjectHandlerMethodReturnValueHandler;
import infra.web.handler.result.RenderedImageReturnValueHandler;
import infra.web.handler.result.SmartReturnValueHandler;
import infra.web.handler.result.StreamingResponseBodyReturnValueHandler;
import infra.web.handler.result.VoidReturnValueHandler;
import infra.web.view.BeanNameViewResolver;
import infra.web.view.ViewResolver;
import infra.web.view.ViewReturnValueHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ReturnValueHandlerManager
extends ApplicationObjectSupport
implements ArraySizeTrimmer,
ReturnValueHandler {
    private final ArrayList<ReturnValueHandler> handlers = new ArrayList(8);
    private final SelectableReturnValueHandler delegate = new SelectableReturnValueHandler(this.handlers);
    @Nullable
    private RedirectModelManager redirectModelManager;
    private ViewReturnValueHandler viewReturnValueHandler;
    @Nullable
    private ObjectHandlerMethodReturnValueHandler objectHandler;
    @Nullable
    private ViewResolver viewResolver;
    private List<HttpMessageConverter<?>> messageConverters;
    private ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();
    private final ArrayList<Object> bodyAdvice = new ArrayList();
    @Nullable
    private AsyncTaskExecutor taskExecutor;
    private String imageFormatName = "png";
    private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
    private final ArrayList<ErrorResponse.Interceptor> errorResponseInterceptors = new ArrayList();

    public ReturnValueHandlerManager() {
        this.messageConverters = new ArrayList(4);
        this.messageConverters.add(new ByteArrayHttpMessageConverter());
        this.messageConverters.add(new StringHttpMessageConverter());
        this.messageConverters.add(new AllEncompassingFormHttpMessageConverter());
    }

    public ReturnValueHandlerManager(List<HttpMessageConverter<?>> messageConverters) {
        this.setMessageConverters(messageConverters);
    }

    public void setReactiveAdapterRegistry(@Nullable ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.reactiveAdapterRegistry = reactiveAdapterRegistry == null ? ReactiveAdapterRegistry.getSharedInstance() : reactiveAdapterRegistry;
    }

    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    public void addHandlers(ReturnValueHandler ... handlers) {
        Assert.notNull((Object)handlers, (String)"ReturnValueHandler is required");
        Collections.addAll(this.handlers, handlers);
    }

    public void addHandlers(List<ReturnValueHandler> handlers) {
        Assert.notNull(handlers, (String)"ReturnValueHandler is required");
        this.handlers.addAll(handlers);
    }

    public void setHandlers(List<ReturnValueHandler> handlers) {
        Assert.notNull(handlers, (String)"ReturnValueHandler is required");
        this.handlers.clear();
        this.handlers.addAll(handlers);
    }

    public List<ReturnValueHandler> getHandlers() {
        return this.handlers;
    }

    public void setErrorResponseInterceptors(List<ErrorResponse.Interceptor> interceptors) {
        this.errorResponseInterceptors.clear();
        this.errorResponseInterceptors.addAll(interceptors);
    }

    public List<ErrorResponse.Interceptor> getErrorResponseInterceptors() {
        return this.errorResponseInterceptors;
    }

    public SelectableReturnValueHandler asSelectable() {
        return new SelectableReturnValueHandler(this.handlers);
    }

    @Nullable
    public ReturnValueHandler getHandler(Object handler) {
        Assert.notNull((Object)handler, (String)"handler is required");
        for (ReturnValueHandler resolver : this.getHandlers()) {
            if (!resolver.supportsHandler(handler)) continue;
            return resolver;
        }
        return null;
    }

    @Nullable
    public ReturnValueHandler getByReturnValue(@Nullable Object returnValue) {
        for (ReturnValueHandler resolver : this.getHandlers()) {
            if (!resolver.supportsReturnValue(returnValue)) continue;
            return resolver;
        }
        return null;
    }

    public ReturnValueHandler obtainHandler(Object handler) {
        ReturnValueHandler returnValueHandler = this.getHandler(handler);
        if (returnValueHandler == null) {
            throw new ReturnValueHandlerNotFoundException(handler);
        }
        return returnValueHandler;
    }

    @Nullable
    public ReturnValueHandler findHandler(Object handler, @Nullable Object returnValue) {
        for (ReturnValueHandler returnValueHandler : this.getHandlers()) {
            SmartReturnValueHandler smartHandler;
            if (!(returnValueHandler instanceof SmartReturnValueHandler ? (smartHandler = (SmartReturnValueHandler)returnValueHandler).supportsHandler(handler, returnValue) : returnValueHandler.supportsHandler(handler) || returnValueHandler.supportsReturnValue(returnValue))) continue;
            return returnValueHandler;
        }
        return null;
    }

    public ReturnValueHandler obtainHandler(Object handler, @Nullable Object returnValue) {
        ReturnValueHandler returnValueHandler = this.findHandler(handler, returnValue);
        if (returnValueHandler == null) {
            throw new ReturnValueHandlerNotFoundException(handler);
        }
        return returnValueHandler;
    }

    @Nullable
    public ReturnValueHandler selectHandler(@Nullable Object handler, @Nullable Object returnValue) {
        return ReturnValueHandler.select(this.handlers, handler, returnValue);
    }

    @Override
    public void handleReturnValue(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        this.delegate.handleReturnValue(context, handler, returnValue);
    }

    @Override
    public boolean supportsHandler(Object handler) {
        return this.delegate.supportsHandler(handler);
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return this.delegate.supportsReturnValue(returnValue);
    }

    public void registerDefaultHandlers() {
        this.logger.debug("Registering default return-value handlers to {}", (Object)this);
        ViewReturnValueHandler viewHandler = this.obtainViewHandler();
        ArrayList<ReturnValueHandler> internalHandlers = new ArrayList<ReturnValueHandler>();
        RenderedImageReturnValueHandler imageHandler = this.getRenderedImageHandler();
        internalHandlers.add(imageHandler);
        internalHandlers.add(viewHandler);
        internalHandlers.add(new VoidReturnValueHandler(viewHandler));
        internalHandlers.add(new HttpStatusReturnValueHandler());
        internalHandlers.add(new HttpHeadersReturnValueHandler());
        internalHandlers.add(new CallableMethodReturnValueHandler());
        internalHandlers.add(new AsyncTaskMethodReturnValueHandler((BeanFactory)this.getApplicationContext()));
        internalHandlers.add(new DeferredResultReturnValueHandler());
        SelectableReturnValueHandler compositeHandler = new SelectableReturnValueHandler(internalHandlers);
        ObjectHandlerMethodReturnValueHandler objectHandler = this.getObjectHandler(compositeHandler);
        List<ReturnValueHandler> handlers = this.getHandlers();
        handlers.add(imageHandler);
        handlers.add(viewHandler);
        handlers.add(new VoidReturnValueHandler(viewHandler));
        handlers.add(new HttpStatusReturnValueHandler());
        handlers.add(new HttpHeadersReturnValueHandler());
        handlers.add(new CallableMethodReturnValueHandler());
        handlers.add(new ModelAttributeMethodProcessor(false));
        handlers.add(new AsyncTaskMethodReturnValueHandler((BeanFactory)this.getApplicationContext()));
        handlers.add(new DeferredResultReturnValueHandler());
        handlers.add(new StreamingResponseBodyReturnValueHandler());
        List<HttpMessageConverter<?>> messageConverters = this.getMessageConverters();
        if (this.taskExecutor != null) {
            handlers.add(new ResponseBodyEmitterReturnValueHandler(messageConverters, this.reactiveAdapterRegistry, (TaskExecutor)this.taskExecutor, this.contentNegotiationManager));
        } else {
            handlers.add(new ResponseBodyEmitterReturnValueHandler(messageConverters, this.contentNegotiationManager));
        }
        handlers.add(new HttpEntityMethodProcessor(messageConverters, this.contentNegotiationManager, this.bodyAdvice, this.redirectModelManager, this.errorResponseInterceptors));
        handlers.add(new RequestResponseBodyMethodProcessor(messageConverters, this.contentNegotiationManager, this.bodyAdvice, this.errorResponseInterceptors));
        handlers.add(new ModelAttributeMethodProcessor(true));
        handlers.add(objectHandler);
        compositeHandler.trimToSize();
    }

    private ViewReturnValueHandler obtainViewHandler() {
        if (this.viewReturnValueHandler == null) {
            ViewResolver viewResolver = this.viewResolver;
            if (viewResolver == null) {
                BeanNameViewResolver resolver = new BeanNameViewResolver();
                resolver.setApplicationContext(this.obtainApplicationContext());
                viewResolver = resolver;
            }
            this.viewReturnValueHandler = new ViewReturnValueHandler(viewResolver);
        }
        return this.viewReturnValueHandler;
    }

    private ObjectHandlerMethodReturnValueHandler getObjectHandler(SelectableReturnValueHandler compositeHandler) {
        ObjectHandlerMethodReturnValueHandler objectHandler = this.get(ObjectHandlerMethodReturnValueHandler.class);
        if (objectHandler == null) {
            objectHandler = new ObjectHandlerMethodReturnValueHandler(compositeHandler);
        }
        return objectHandler;
    }

    private RenderedImageReturnValueHandler getRenderedImageHandler() {
        RenderedImageReturnValueHandler imageHandler = this.get(RenderedImageReturnValueHandler.class);
        if (imageHandler == null) {
            imageHandler = new RenderedImageReturnValueHandler();
            imageHandler.setFormatName(this.imageFormatName);
        }
        return imageHandler;
    }

    public boolean removeIf(Predicate<ReturnValueHandler> filter) {
        return this.handlers.removeIf(filter);
    }

    public boolean contains(@Nullable Class<?> handlerClass) {
        return handlerClass != null && this.contains(handlerClass, this.handlers);
    }

    protected boolean contains(Class<?> handlerClass, List<ReturnValueHandler> handlers) {
        return this.get(handlerClass, handlers) != null;
    }

    @Nullable
    public <T> T get(@Nullable Class<T> handlerClass) {
        if (handlerClass == null) {
            return null;
        }
        return this.get(handlerClass, this.handlers);
    }

    @Nullable
    protected final <T> T get(Class<T> handlerClass, List<ReturnValueHandler> handlers) {
        for (ReturnValueHandler handler : handlers) {
            if (!handlerClass.isInstance(handler)) continue;
            return (T)handler;
        }
        return null;
    }

    public void trimToSize() {
        this.handlers.trimToSize();
    }

    public void setViewResolver(@Nullable ViewResolver webViewResolver) {
        this.viewResolver = webViewResolver;
    }

    public void setRedirectModelManager(@Nullable RedirectModelManager redirectModelManager) {
        this.redirectModelManager = redirectModelManager;
    }

    @Nullable
    public RedirectModelManager getRedirectModelManager() {
        return this.redirectModelManager;
    }

    public void setObjectHandler(@Nullable ObjectHandlerMethodReturnValueHandler objectHandler) {
        this.objectHandler = objectHandler;
    }

    @Nullable
    public ObjectHandlerMethodReturnValueHandler getObjectHandler() {
        return this.objectHandler;
    }

    public void setImageFormatName(String imageFormatName) {
        Assert.notNull((Object)imageFormatName, (String)"imageFormatName is required");
        this.imageFormatName = imageFormatName;
    }

    public String getImageFormatName() {
        return this.imageFormatName;
    }

    public void setContentNegotiationManager(@Nullable ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"messageConverters is required");
        this.messageConverters = messageConverters;
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void addRequestResponseBodyAdvice(@Nullable List<Object> list) {
        CollectionUtils.addAll(this.bodyAdvice, list);
    }

    public void setRequestResponseBodyAdvice(@Nullable List<Object> list) {
        this.bodyAdvice.clear();
        CollectionUtils.addAll(this.bodyAdvice, list);
    }

    public List<Object> getRequestResponseBodyAdvice() {
        return this.bodyAdvice;
    }

    public void setViewReturnValueHandler(@Nullable ViewReturnValueHandler viewReturnValueHandler) {
        this.viewReturnValueHandler = viewReturnValueHandler;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReturnValueHandlerManager)) {
            return false;
        }
        ReturnValueHandlerManager that = (ReturnValueHandlerManager)o;
        return Objects.equals(this.handlers, that.handlers) && Objects.equals(this.viewResolver, that.viewResolver) && Objects.equals(this.objectHandler, that.objectHandler) && Objects.equals(this.imageFormatName, that.imageFormatName) && Objects.equals(this.messageConverters, that.messageConverters) && Objects.equals(this.redirectModelManager, that.redirectModelManager) && Objects.equals(this.viewReturnValueHandler, that.viewReturnValueHandler) && Objects.equals(this.contentNegotiationManager, that.contentNegotiationManager) && Objects.equals(this.bodyAdvice, that.bodyAdvice);
    }

    public int hashCode() {
        return Objects.hash(this.handlers, this.redirectModelManager, this.viewReturnValueHandler, this.objectHandler, this.viewResolver, this.messageConverters, this.contentNegotiationManager, this.bodyAdvice, this.imageFormatName);
    }

    public String toString() {
        return ToStringBuilder.from((Object)this).append("handlers", this.handlers).append("viewResolver", (Object)this.viewResolver).append("messageConverters", this.messageConverters).append("requestResponseBodyAdvice", this.bodyAdvice).toString();
    }
}

