/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.context.MessageSource;
import infra.context.MessageSourceAware;
import infra.core.annotation.AnnotatedElementUtils;
import infra.core.i18n.LocaleContextHolder;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.ResponseStatusException;
import infra.web.annotation.ResponseStatus;
import infra.web.handler.AbstractHandlerExceptionHandler;
import java.io.IOException;

public class ResponseStatusExceptionHandler
extends AbstractHandlerExceptionHandler
implements MessageSourceAware {
    @Nullable
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    @Nullable
    protected Object handleInternal(RequestContext request, @Nullable Object handler, Throwable ex) {
        try {
            if (ex instanceof ResponseStatusException) {
                return this.resolveResponseStatusException((ResponseStatusException)((Object)ex), request, handler);
            }
            ResponseStatus status = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(ex.getClass(), ResponseStatus.class);
            if (status != null) {
                return this.resolveResponseStatus(status, request, handler, ex);
            }
            if (ex.getCause() instanceof Exception) {
                return this.handleInternal(request, handler, ex.getCause());
            }
        }
        catch (Exception resolveEx) {
            this.logResultedInException(ex, resolveEx);
        }
        return null;
    }

    protected Object resolveResponseStatus(ResponseStatus responseStatus, RequestContext request, @Nullable Object handler, Throwable ex) throws Exception {
        int statusCode = responseStatus.code().value();
        String reason = responseStatus.reason();
        return this.applyStatusAndReason(statusCode, reason, request);
    }

    protected Object resolveResponseStatusException(ResponseStatusException ex, RequestContext request, @Nullable Object handler) throws Exception {
        request.mergeToResponse(ex.getHeaders());
        return this.applyStatusAndReason(ex.getStatusCode().value(), ex.getReason(), request);
    }

    protected Object applyStatusAndReason(int statusCode, @Nullable String reason, RequestContext request) throws IOException {
        if (StringUtils.hasText((String)reason)) {
            if (this.messageSource != null) {
                reason = this.messageSource.getMessage(reason, null, reason, LocaleContextHolder.getLocale());
            }
            request.sendError(statusCode, reason);
        } else {
            request.sendError(statusCode);
        }
        return NONE_RETURN_VALUE;
    }
}

