/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.beans.ConversionNotSupportedException;
import infra.beans.TypeMismatchException;
import infra.context.MessageSource;
import infra.context.MessageSourceAware;
import infra.core.i18n.LocaleContextHolder;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ProblemDetail;
import infra.http.ResponseEntity;
import infra.http.converter.HttpMessageNotReadableException;
import infra.http.converter.HttpMessageNotWritableException;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.MultiValueMap;
import infra.validation.BindException;
import infra.web.ErrorResponse;
import infra.web.ErrorResponseException;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.HttpMediaTypeNotSupportedException;
import infra.web.HttpRequestMethodNotSupportedException;
import infra.web.NotFoundHandler;
import infra.web.RequestContext;
import infra.web.annotation.ExceptionHandler;
import infra.web.async.AsyncRequestTimeoutException;
import infra.web.bind.MethodArgumentNotValidException;
import infra.web.bind.MissingPathVariableException;
import infra.web.bind.MissingRequestParameterException;
import infra.web.bind.RequestBindingException;
import infra.web.bind.resolver.MissingRequestPartException;
import infra.web.handler.HandlerNotFoundException;
import infra.web.multipart.MaxUploadSizeExceededException;
import infra.web.util.WebUtils;

public class ResponseEntityExceptionHandler
implements MessageSourceAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Nullable
    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, MissingPathVariableException.class, MissingRequestParameterException.class, MissingRequestPartException.class, RequestBindingException.class, MethodArgumentNotValidException.class, HandlerNotFoundException.class, AsyncRequestTimeoutException.class, ErrorResponseException.class, MaxUploadSizeExceededException.class, ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, BindException.class})
    @Nullable
    public final ResponseEntity<Object> handleException(Exception ex, RequestContext request) throws Exception {
        if (ex instanceof ErrorResponse) {
            ErrorResponse errorEx = (ErrorResponse)((Object)ex);
            if (ex instanceof HttpRequestMethodNotSupportedException) {
                HttpRequestMethodNotSupportedException subEx = (HttpRequestMethodNotSupportedException)((Object)ex);
                return this.handleHttpRequestMethodNotSupported(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof HttpMediaTypeNotSupportedException) {
                HttpMediaTypeNotSupportedException subEx = (HttpMediaTypeNotSupportedException)((Object)ex);
                return this.handleHttpMediaTypeNotSupported(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof HttpMediaTypeNotAcceptableException) {
                HttpMediaTypeNotAcceptableException subEx = (HttpMediaTypeNotAcceptableException)((Object)ex);
                return this.handleHttpMediaTypeNotAcceptable(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MissingPathVariableException) {
                MissingPathVariableException subEx = (MissingPathVariableException)((Object)ex);
                return this.handleMissingPathVariable(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MissingRequestParameterException) {
                MissingRequestParameterException subEx = (MissingRequestParameterException)((Object)ex);
                return this.handleMissingRequestParameter(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MissingRequestPartException) {
                MissingRequestPartException subEx = (MissingRequestPartException)((Object)ex);
                return this.handleMissingRequestPart(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof RequestBindingException) {
                RequestBindingException subEx = (RequestBindingException)((Object)ex);
                return this.handleRequestBindingException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MethodArgumentNotValidException) {
                MethodArgumentNotValidException subEx = (MethodArgumentNotValidException)((Object)ex);
                return this.handleMethodArgumentNotValid(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof HandlerNotFoundException) {
                HandlerNotFoundException subEx = (HandlerNotFoundException)((Object)ex);
                return this.handleHandlerNotFoundException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof AsyncRequestTimeoutException) {
                AsyncRequestTimeoutException subEx = (AsyncRequestTimeoutException)ex;
                return this.handleAsyncRequestTimeoutException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof ErrorResponseException) {
                ErrorResponseException subEx = (ErrorResponseException)((Object)ex);
                return this.handleErrorResponseException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MaxUploadSizeExceededException) {
                MaxUploadSizeExceededException subEx = (MaxUploadSizeExceededException)((Object)ex);
                return this.handleMaxUploadSizeExceededException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            return this.handleExceptionInternal(ex, null, errorEx.getHeaders(), errorEx.getStatusCode(), request);
        }
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        if (ex instanceof ConversionNotSupportedException) {
            ConversionNotSupportedException subEx = (ConversionNotSupportedException)ex;
            return this.handleConversionNotSupported(subEx, headers, HttpStatus.INTERNAL_SERVER_ERROR, request);
        }
        if (ex instanceof TypeMismatchException) {
            TypeMismatchException subEx = (TypeMismatchException)ex;
            return this.handleTypeMismatch(subEx, headers, HttpStatus.BAD_REQUEST, request);
        }
        if (ex instanceof HttpMessageNotReadableException) {
            HttpMessageNotReadableException subEx = (HttpMessageNotReadableException)((Object)ex);
            return this.handleHttpMessageNotReadable(subEx, headers, HttpStatus.BAD_REQUEST, request);
        }
        if (ex instanceof HttpMessageNotWritableException) {
            HttpMessageNotWritableException subEx = (HttpMessageNotWritableException)((Object)ex);
            return this.handleHttpMessageNotWritable(subEx, headers, HttpStatus.INTERNAL_SERVER_ERROR, request);
        }
        if (ex instanceof BindException) {
            BindException subEx = (BindException)ex;
            return this.handleBindException(subEx, headers, HttpStatus.BAD_REQUEST, request);
        }
        throw ex;
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        NotFoundHandler.pageNotFoundLogger.warn(ex.getMessage());
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingPathVariable(MissingPathVariableException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingRequestParameter(MissingRequestParameterException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingRequestPart(MissingRequestPartException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleRequestBindingException(RequestBindingException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHandlerNotFoundException(HandlerNotFoundException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal(ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleErrorResponseException(ErrorResponseException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleConversionNotSupported(ConversionNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        Object[] args = new Object[]{ex.getPropertyName(), ex.getValue()};
        String defaultDetail = "Failed to convert '%s' with value: '%s'".formatted(args[0], args[1]);
        ProblemDetail body = this.createProblemDetail((Exception)ex, status, defaultDetail, null, args, request);
        return this.handleExceptionInternal((Exception)ex, body, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        Object[] args = new Object[]{ex.getPropertyName(), ex.getValue()};
        String defaultDetail = "Failed to convert '%s' with value: '%s'".formatted(args[0], args[1]);
        String messageCode = ErrorResponse.getDefaultDetailMessageCode(TypeMismatchException.class, null);
        ProblemDetail body = this.createProblemDetail((Exception)ex, status, defaultDetail, messageCode, args, request);
        return this.handleExceptionInternal((Exception)ex, body, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        ProblemDetail body = this.createProblemDetail((Exception)((Object)ex), status, "Failed to read request", null, null, request);
        return this.handleExceptionInternal((Exception)((Object)ex), body, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        ProblemDetail body = this.createProblemDetail((Exception)((Object)ex), status, "Failed to write request", null, null, request);
        return this.handleExceptionInternal((Exception)((Object)ex), body, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatusCode status, RequestContext request) {
        ProblemDetail body = this.createProblemDetail((Exception)ex, status, "Failed to bind request", null, null, request);
        return this.handleExceptionInternal((Exception)ex, body, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, @Nullable HttpHeaders headers, HttpStatusCode statusCode, RequestContext request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.isSameCodeAs(statusCode)) {
            request.setAttribute(WebUtils.ERROR_EXCEPTION_ATTRIBUTE, ex);
        }
        if (body == null && ex instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)((Object)ex);
            body = errorResponse.updateAndGetBody(this.messageSource, LocaleContextHolder.getLocale());
        }
        return this.createResponseEntity(body, headers, statusCode, request);
    }

    protected ProblemDetail createProblemDetail(Exception ex, HttpStatusCode status, String defaultDetail, @Nullable String detailMessageCode, @Nullable Object[] detailMessageArguments, RequestContext request) {
        ErrorResponse.Builder builder = ErrorResponse.builder(ex, status, defaultDetail);
        if (detailMessageCode != null) {
            builder.detailMessageCode(detailMessageCode);
        }
        if (detailMessageArguments != null) {
            builder.detailMessageArguments(detailMessageArguments);
        }
        return builder.build().updateAndGetBody(this.messageSource, LocaleContextHolder.getLocale());
    }

    protected ResponseEntity<Object> createResponseEntity(@Nullable Object body, @Nullable HttpHeaders headers, HttpStatusCode statusCode, RequestContext request) {
        return new ResponseEntity<Object>(body, (MultiValueMap<String, String>)headers, statusCode);
    }
}

