/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.core.AntPathMatcher;
import infra.core.PathMatcher;
import infra.http.server.PathContainer;
import infra.http.server.RequestPath;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.web.HandlerInterceptor;
import infra.web.InterceptorChain;
import infra.web.RequestContext;
import infra.web.util.WebUtils;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PathPatternParser;
import infra.web.util.pattern.PatternParseException;

public final class MappedInterceptor
implements HandlerInterceptor {
    private static final PathMatcher defaultPathMatcher = new AntPathMatcher();
    @Nullable
    private final CompiledPattern[] includePatterns;
    @Nullable
    private final CompiledPattern[] excludePatterns;
    private final HandlerInterceptor interceptor;
    private PathMatcher pathMatcher = defaultPathMatcher;

    public MappedInterceptor(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, HandlerInterceptor interceptor, @Nullable PathPatternParser parser) {
        this.includePatterns = CompiledPattern.initPatterns(includePatterns, parser);
        this.excludePatterns = CompiledPattern.initPatterns(excludePatterns, parser);
        this.interceptor = interceptor;
    }

    public MappedInterceptor(@Nullable String[] includePatterns, HandlerInterceptor interceptor) {
        this(includePatterns, null, interceptor);
    }

    public MappedInterceptor(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, HandlerInterceptor interceptor) {
        this(includePatterns, excludePatterns, interceptor, null);
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"pathMatcher is required");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Nullable
    public String[] getPathPatterns() {
        if (ObjectUtils.isNotEmpty((Object[])this.includePatterns)) {
            int i = 0;
            String[] patterns = new String[this.includePatterns.length];
            for (CompiledPattern includePattern : this.includePatterns) {
                patterns[i++] = includePattern.patternString;
            }
            return patterns;
        }
        return null;
    }

    public HandlerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public boolean matches(RequestContext request) {
        RequestPath lookupPath = request.getRequestPath();
        return this.matches(lookupPath);
    }

    public boolean matches(PathContainer lookupPath) {
        if (ObjectUtils.isNotEmpty((Object[])this.excludePatterns)) {
            for (CompiledPattern adapter : this.excludePatterns) {
                if (!this.doMatch(adapter, lookupPath)) continue;
                return false;
            }
        }
        if (ObjectUtils.isEmpty((Object[])this.includePatterns)) {
            return true;
        }
        for (CompiledPattern adapter : this.includePatterns) {
            if (!this.doMatch(adapter, lookupPath)) continue;
            return true;
        }
        return false;
    }

    private boolean doMatch(CompiledPattern adapter, PathContainer path) {
        PathPattern pathPattern = adapter.pathPattern;
        if (pathPattern != null) {
            return pathPattern.matches(path);
        }
        String lookupPath = WebUtils.removeSemicolonContent(path.value());
        return this.pathMatcher.match(adapter.patternString, lookupPath);
    }

    @Override
    public boolean beforeProcess(RequestContext request, Object handler) throws Throwable {
        return this.interceptor.beforeProcess(request, handler);
    }

    @Override
    public void afterProcess(RequestContext request, Object handler, @Nullable Object result) throws Throwable {
        this.interceptor.afterProcess(request, handler, result);
    }

    @Override
    @Nullable
    public Object intercept(RequestContext request, InterceptorChain chain) throws Throwable {
        if (this.matches(request)) {
            return this.interceptor.intercept(request, chain);
        }
        return chain.proceed(request);
    }

    private static final class CompiledPattern {
        public final String patternString;
        @Nullable
        public final PathPattern pathPattern;

        public CompiledPattern(String pattern, @Nullable PathPatternParser parser) {
            this.patternString = pattern;
            this.pathPattern = CompiledPattern.initPathPattern(pattern, parser);
        }

        @Nullable
        private static PathPattern initPathPattern(String pattern, @Nullable PathPatternParser parser) {
            if (parser == null) {
                parser = PathPatternParser.defaultInstance;
            }
            try {
                return parser.parse(pattern);
            }
            catch (PatternParseException ex) {
                return null;
            }
        }

        @Nullable
        public static CompiledPattern[] initPatterns(@Nullable String[] patterns, @Nullable PathPatternParser parser) {
            if (ObjectUtils.isEmpty((Object[])patterns)) {
                return null;
            }
            int i = 0;
            CompiledPattern[] result = new CompiledPattern[patterns.length];
            for (String pattern : patterns) {
                result[i++] = new CompiledPattern(pattern, parser);
            }
            return result;
        }
    }
}

