/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.lang.Assert;
import infra.web.HandlerMapping;
import infra.web.RequestContext;
import java.util.List;
import java.util.Objects;

public class HandlerRegistries
implements HandlerMapping {
    private final HandlerMapping[] handlerRegistries;

    public HandlerRegistries(HandlerMapping ... registries) {
        Assert.notNull((Object)registries, (String)"handler-registries is required");
        this.handlerRegistries = registries;
    }

    public HandlerRegistries(List<HandlerMapping> registries) {
        this(Objects.requireNonNull(registries).toArray(new HandlerMapping[registries.size()]));
    }

    @Override
    public Object getHandler(RequestContext request) throws Exception {
        for (HandlerMapping registry : this.handlerRegistries) {
            Object ret = registry.getHandler(request);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

