/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.web.ErrorResponse;
import infra.web.InfraConfigurationException;

public class HandlerNotFoundException
extends InfraConfigurationException
implements ErrorResponse {
    private final String httpMethod;
    private final String requestURI;
    private final HttpHeaders requestHeaders;

    public HandlerNotFoundException(String httpMethod, String requestURI, HttpHeaders headers) {
        super("No endpoint %s %s.".formatted(httpMethod, requestURI));
        this.httpMethod = httpMethod;
        this.requestURI = requestURI;
        this.requestHeaders = headers;
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.NOT_FOUND;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public HttpHeaders getRequestHeaders() {
        return this.requestHeaders;
    }
}

