/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.lang.Nullable;
import infra.web.HandlerAdapter;
import infra.web.HandlerInterceptor;
import infra.web.HandlerWrapper;
import infra.web.HttpRequestHandler;
import infra.web.InterceptorChain;
import infra.web.RequestContext;
import infra.web.handler.HandlerAdapterAware;

public class HandlerExecutionChain
implements HandlerWrapper,
HandlerAdapterAware,
HttpRequestHandler {
    private final Object handler;
    private HandlerAdapter handlerAdapter;
    @Nullable
    private final HandlerInterceptor[] interceptors;

    public HandlerExecutionChain(Object handler) {
        this(handler, null);
    }

    public HandlerExecutionChain(Object handler, @Nullable HandlerInterceptor[] interceptors) {
        this.handler = handler;
        this.interceptors = interceptors;
    }

    @Override
    public Object getRawHandler() {
        return this.handler;
    }

    @Override
    public void setHandlerAdapter(HandlerAdapter handlerAdapter) {
        this.handlerAdapter = handlerAdapter;
    }

    public HandlerExecutionChain withInterceptors(@Nullable HandlerInterceptor[] interceptors) {
        return new HandlerExecutionChain(this.handler, interceptors);
    }

    public String toString() {
        return "HandlerExecutionChain with [%s] and %d interceptors".formatted(this.handler, this.interceptors != null ? this.interceptors.length : 0);
    }

    @Override
    @Nullable
    public Object handleRequest(RequestContext request) throws Throwable {
        HandlerInterceptor[] interceptors = this.interceptors;
        if (interceptors == null) {
            return this.handlerAdapter.handle(request, this.handler);
        }
        return new Chain(interceptors, this.handler).proceed(request);
    }

    @Nullable
    public HandlerInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    private final class Chain
    extends InterceptorChain {
        private Chain(HandlerInterceptor[] interceptors, Object handler) {
            super(interceptors, handler);
        }

        @Override
        protected Object invokeHandler(RequestContext context, Object handler) throws Throwable {
            return HandlerExecutionChain.this.handlerAdapter.handle(context, handler);
        }
    }
}

