/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.HandlerAdapter;
import infra.web.HandlerAdapterNotFoundException;
import infra.web.HttpRequestHandler;
import infra.web.RequestContext;

public class HandlerAdapters
implements HandlerAdapter {
    private final HandlerAdapter[] handlerAdapters;

    public HandlerAdapters(HandlerAdapter[] handlerAdapters) {
        Assert.notNull((Object)handlerAdapters, (String)"HandlerAdapters is required");
        this.handlerAdapters = handlerAdapters;
    }

    @Override
    public boolean supports(Object handler) {
        return this.selectAdapter(handler) != null;
    }

    @Override
    public Object handle(RequestContext context, Object handler) throws Throwable {
        if (handler instanceof HttpRequestHandler) {
            HttpRequestHandler httpRequestHandler = (HttpRequestHandler)handler;
            return httpRequestHandler.handleRequest(context);
        }
        for (HandlerAdapter handlerAdapter : this.handlerAdapters) {
            if (!handlerAdapter.supports(handler)) continue;
            return handlerAdapter.handle(context, handler);
        }
        throw new HandlerAdapterNotFoundException(handler);
    }

    @Nullable
    public HandlerAdapter selectAdapter(Object handler) {
        for (HandlerAdapter handlerAdapter : this.handlerAdapters) {
            if (!handlerAdapter.supports(handler)) continue;
            return handlerAdapter;
        }
        return null;
    }
}

