/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.core.OrderedSupport;
import infra.lang.Nullable;
import infra.web.HandlerExceptionHandler;
import infra.web.RequestContext;
import java.util.List;

public class CompositeHandlerExceptionHandler
extends OrderedSupport
implements HandlerExceptionHandler {
    @Nullable
    private List<HandlerExceptionHandler> handlers;

    public CompositeHandlerExceptionHandler() {
    }

    public CompositeHandlerExceptionHandler(List<HandlerExceptionHandler> handlers) {
        this.handlers = handlers;
    }

    public void setExceptionHandlers(@Nullable List<HandlerExceptionHandler> handlers) {
        this.handlers = handlers;
    }

    @Nullable
    public List<HandlerExceptionHandler> getExceptionHandlers() {
        return this.handlers;
    }

    @Override
    public Object handleException(RequestContext context, Throwable exception, Object handler) throws Exception {
        List<HandlerExceptionHandler> handlers = this.getExceptionHandlers();
        if (handlers != null) {
            for (HandlerExceptionHandler exceptionHandler : handlers) {
                Object view = exceptionHandler.handleException(context, exception, handler);
                if (view == null) continue;
                return view;
            }
        }
        return null;
    }
}

