/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.beans.BeansException;
import infra.context.ApplicationContext;
import infra.http.server.RequestPath;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.handler.AbstractHandlerMapping;
import infra.web.util.pattern.PathPattern;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    @Nullable
    private Object rootHandler;
    private boolean lazyInitHandlers = false;
    private final LinkedHashMap<String, Object> handlerMap = new LinkedHashMap();
    private final LinkedHashMap<PathPattern, Object> pathPatternHandlerMap = new LinkedHashMap();

    public void setRootHandler(@Nullable Object rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Nullable
    public Object getRootHandler() {
        return this.rootHandler;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    @Override
    @Nullable
    protected Object getHandlerInternal(RequestContext request) {
        Object handler = this.lookupHandler(request);
        if (handler == null) {
            Object rawHandler = null;
            String lookupPath = request.getRequestPath().value();
            if (StringUtils.matchesCharacter((String)lookupPath, (char)'/')) {
                rawHandler = this.getRootHandler();
            }
            if (rawHandler == null) {
                rawHandler = this.getDefaultHandler();
            }
            if (rawHandler != null) {
                if (rawHandler instanceof String) {
                    String handlerName = (String)rawHandler;
                    rawHandler = this.obtainApplicationContext().getBean(handlerName);
                }
                this.validateHandler(rawHandler, request);
                handler = rawHandler;
            }
        }
        return handler;
    }

    @Nullable
    protected Object lookupHandler(RequestContext request) {
        PathPattern bestMatchingPattern;
        RequestPath lookupPath = request.getRequestPath();
        String requestPath = lookupPath.value();
        Object handler = this.getDirectMatch(requestPath, request);
        if (handler != null) {
            HandlerMatchingMetadata matchingMetadata = new HandlerMatchingMetadata(handler, requestPath, lookupPath, null, this.getPatternParser());
            request.setMatchingMetadata(matchingMetadata);
            return handler;
        }
        ArrayList<PathPattern> matches = null;
        for (PathPattern pattern : this.pathPatternHandlerMap.keySet()) {
            if (!pattern.matches(lookupPath)) continue;
            if (matches == null) {
                matches = new ArrayList<PathPattern>();
            }
            matches.add(pattern);
        }
        if (matches == null) {
            return null;
        }
        if (matches.size() > 1) {
            matches.sort(PathPattern.SPECIFICITY_COMPARATOR);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Matching patterns {}", matches);
            }
        }
        if ((handler = this.pathPatternHandlerMap.get(bestMatchingPattern = (PathPattern)matches.get(0))) instanceof String) {
            String handlerName = (String)handler;
            handler = this.obtainApplicationContext().getBean(handlerName);
        }
        this.validateHandler(handler, request);
        HandlerMatchingMetadata matchingMetadata = new HandlerMatchingMetadata(handler, requestPath, lookupPath, bestMatchingPattern, this.getPatternParser());
        request.setMatchingMetadata(matchingMetadata);
        return handler;
    }

    @Nullable
    private Object getDirectMatch(String urlPath, RequestContext request) {
        Object handler = this.handlerMap.get(urlPath);
        if (handler != null) {
            if (handler instanceof String) {
                String handlerName = (String)handler;
                handler = this.obtainApplicationContext().getBean(handlerName);
            }
            this.validateHandler(handler, request);
            return handler;
        }
        return null;
    }

    protected void validateHandler(Object handler, RequestContext request) {
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, (String)"URL path array is required");
        for (String urlPath : urlPaths) {
            this.registerHandler(urlPath, (Object)beanName);
        }
    }

    public void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Object mappedHandler;
        Assert.notNull((Object)urlPath, (String)"URL path is required");
        Assert.notNull((Object)handler, (String)"Handler object is required");
        Object resolvedHandler = handler;
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            ApplicationContext beanFactory = this.obtainApplicationContext();
            if (beanFactory.isSingleton(handlerName)) {
                resolvedHandler = beanFactory.getBean(handlerName);
            }
        }
        if ((mappedHandler = this.handlerMap.get(urlPath)) != null) {
            if (mappedHandler != resolvedHandler) {
                throw new IllegalStateException("Cannot map %s to URL path [%s]: There is already %s mapped.".formatted(this.getHandlerDescription(handler), urlPath, this.getHandlerDescription(mappedHandler)));
            }
        } else if (urlPath.equals("/")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Root mapping to {}", (Object)this.getHandlerDescription(handler));
            }
            this.setRootHandler(resolvedHandler);
        } else if (urlPath.equals("/*")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Default mapping to {}", (Object)this.getHandlerDescription(handler));
            }
            this.setDefaultHandler(resolvedHandler);
        } else {
            PathPattern pathPattern = this.getPatternParser().parse(urlPath);
            this.duPutHandler(urlPath, resolvedHandler);
            this.doPutPathPattern(pathPattern, resolvedHandler);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Mapped [{}] onto {}", (Object)urlPath, (Object)this.getHandlerDescription(handler));
            }
        }
    }

    public void unregisterHandler(String urlPath) {
        Assert.notNull((Object)urlPath, (String)"URL path is required");
        if (urlPath.equals("/")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Removing root mapping: " + this.getRootHandler());
            }
            this.setRootHandler(null);
        } else if (urlPath.equals("/*")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Removing default mapping: " + this.getDefaultHandler());
            }
            this.setDefaultHandler(null);
        } else {
            Object mappedHandler = this.handlerMap.get(urlPath);
            if (mappedHandler == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No mapping for [%s]".formatted(urlPath));
                }
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Removing mapping \"{}\": {}", (Object)urlPath, (Object)this.getHandlerDescription(mappedHandler));
                }
                this.handlerMap.remove(urlPath);
                this.pathPatternHandlerMap.remove(this.getPatternParser().parse(urlPath));
            }
        }
    }

    protected void doPutPathPattern(PathPattern pathPattern, Object resolvedHandler) {
        this.pathPatternHandlerMap.put(pathPattern, resolvedHandler);
    }

    protected void duPutHandler(String urlPath, Object resolvedHandler) {
        this.handlerMap.put(urlPath, resolvedHandler);
    }

    private String getHandlerDescription(Object handler) {
        return handler instanceof String ? "'%s'".formatted(handler) : handler.toString();
    }

    public final Map<String, Object> getHandlerMap() {
        return this.handlerMap;
    }

    public final Map<PathPattern, Object> getPathPatternHandlerMap() {
        return this.pathPatternHandlerMap;
    }
}

