/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.beans.BeansException;
import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.BeanNameAware;
import infra.context.expression.EmbeddedValueResolverAware;
import infra.context.support.ApplicationObjectSupport;
import infra.core.Ordered;
import infra.core.StringValueResolver;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.LogDelegateFactory;
import infra.logging.Logger;
import infra.util.CollectionUtils;
import infra.web.HandlerInterceptor;
import infra.web.HandlerMapping;
import infra.web.HandlerMatchingMetadata;
import infra.web.HandlerWrapper;
import infra.web.HttpRequestHandler;
import infra.web.RequestContext;
import infra.web.cors.CorsConfiguration;
import infra.web.cors.CorsConfigurationSource;
import infra.web.cors.CorsProcessor;
import infra.web.cors.DefaultCorsProcessor;
import infra.web.cors.UrlBasedCorsConfigurationSource;
import infra.web.handler.HandlerExecutionChain;
import infra.web.handler.MappedInterceptor;
import infra.web.util.pattern.PathPatternParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractHandlerMapping
extends ApplicationObjectSupport
implements HandlerMapping,
Ordered,
EmbeddedValueResolverAware,
BeanNameAware {
    protected final Logger mappingsLogger = LogDelegateFactory.getHiddenLog((String)(HandlerMapping.class.getName() + ".Mappings"));
    @Nullable
    private Object defaultHandler;
    private int order = Integer.MAX_VALUE;
    @Nullable
    private String beanName;
    @Nullable
    protected StringValueResolver embeddedValueResolver;
    private final PathPatternParser patternParser = new PathPatternParser();
    private final ArrayList<HandlerInterceptor> interceptors = new ArrayList();
    @Nullable
    private CorsConfigurationSource corsConfigurationSource;
    private CorsProcessor corsProcessor = new DefaultCorsProcessor();

    public void setUseTrailingSlashMatch(boolean trailingSlashMatch) {
        this.patternParser.setMatchOptionalTrailingSeparator(trailingSlashMatch);
    }

    public void setInterceptors(Object ... interceptors) {
        CollectionUtils.addAll(this.interceptors, (Object[])interceptors);
    }

    public void setCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations) {
        if (CollectionUtils.isEmpty(corsConfigurations)) {
            this.corsConfigurationSource = null;
        } else {
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(this.getPatternParser());
            source.setCorsConfigurations(corsConfigurations);
            this.setCorsConfigurationSource(source);
        }
    }

    public void setCorsConfigurationSource(CorsConfigurationSource source) {
        Assert.notNull((Object)source, (String)"CorsConfigurationSource is required");
        this.corsConfigurationSource = source;
    }

    public void setCorsProcessor(CorsProcessor corsProcessor) {
        Assert.notNull((Object)corsProcessor, (String)"CorsProcessor is required");
        this.corsProcessor = corsProcessor;
    }

    public CorsProcessor getCorsProcessor() {
        return this.corsProcessor;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected String formatMappingName() {
        return this.beanName != null ? "'" + this.beanName + "'" : this.getClass().getName();
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Nullable
    protected String resolveEmbeddedVariables(String expression) {
        if (this.embeddedValueResolver != null) {
            return this.embeddedValueResolver.resolveStringValue(expression);
        }
        return expression;
    }

    @Nullable
    public CorsConfigurationSource getCorsConfigurationSource() {
        return this.corsConfigurationSource;
    }

    public void setDefaultHandler(@Nullable Object defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    @Nullable
    public Object getDefaultHandler() {
        return this.defaultHandler;
    }

    public PathPatternParser getPatternParser() {
        return this.patternParser;
    }

    public void setUseCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.patternParser.setCaseSensitive(caseSensitiveMatch);
    }

    protected void initApplicationContext() throws BeansException {
        this.extendInterceptors(this.interceptors);
        this.detectMappedInterceptors(this.interceptors);
    }

    protected void extendInterceptors(List<HandlerInterceptor> interceptors) {
    }

    protected void detectMappedInterceptors(List<HandlerInterceptor> mappedInterceptors) {
        mappedInterceptors.addAll(BeanFactoryUtils.beansOfTypeIncludingAncestors((BeanFactory)this.obtainApplicationContext(), MappedInterceptor.class, (boolean)true, (boolean)false).values());
    }

    @Override
    @Nullable
    public final Object getHandler(RequestContext request) throws Exception {
        HandlerExecutionChain chain;
        Object handler = this.getHandlerInternal(request);
        if (handler == null) {
            handler = this.getDefaultHandler();
        }
        if (handler == null) {
            return null;
        }
        if (handler instanceof String) {
            handler = this.obtainApplicationContext().getBean((String)handler);
        }
        if (this.hasCorsConfigurationSource(handler) || request.isPreFlightRequest()) {
            CorsConfiguration globalConfig;
            CorsConfiguration config = this.getCorsConfiguration(handler, request);
            CorsConfigurationSource global = this.getCorsConfigurationSource();
            if (global != null && (globalConfig = global.getCorsConfiguration(request)) != null) {
                config = globalConfig.combine(config);
            }
            if (config != null) {
                config.validateAllowCredentials();
                config.validateAllowPrivateNetwork();
            }
            chain = this.getCorsHandlerExecutionChain(request, handler, config);
        } else {
            chain = this.getHandlerExecutionChain(handler, null);
        }
        if (!request.hasMatchingMetadata()) {
            request.setMatchingMetadata(new HandlerMatchingMetadata(handler, request, this.patternParser));
        }
        return chain;
    }

    @Nullable
    protected abstract Object getHandlerInternal(RequestContext var1) throws Exception;

    protected HandlerExecutionChain getHandlerExecutionChain(Object handler, @Nullable HandlerInterceptor firstInterceptor) {
        ArrayList<HandlerInterceptor> global;
        HandlerInterceptor[] interceptorsArr;
        ArrayList<Object> interceptors = null;
        if (firstInterceptor != null) {
            interceptors = new ArrayList<HandlerInterceptor>(4);
            interceptors.add(firstInterceptor);
        }
        if ((interceptorsArr = this.getHandlerInterceptors(handler)) != null) {
            if (interceptors == null) {
                interceptors = new ArrayList(interceptorsArr.length + 2);
            }
            for (HandlerInterceptor interceptor : interceptorsArr) {
                interceptors.add(interceptor);
            }
        }
        if (!(global = this.interceptors).isEmpty()) {
            if (interceptors == null) {
                interceptors = new ArrayList<HandlerInterceptor>(global);
            } else {
                interceptors.addAll(global);
            }
        }
        return new HandlerExecutionChain(handler, interceptors == null ? null : interceptors.toArray(new HandlerInterceptor[interceptors.size()]));
    }

    @Nullable
    protected HandlerInterceptor[] getHandlerInterceptors(Object handler) {
        return null;
    }

    protected boolean hasCorsConfigurationSource(Object handler) {
        if (handler instanceof HandlerWrapper) {
            HandlerWrapper wrapper = (HandlerWrapper)handler;
            handler = wrapper.getRawHandler();
        }
        return handler instanceof CorsConfigurationSource || this.corsConfigurationSource != null;
    }

    @Nullable
    protected CorsConfiguration getCorsConfiguration(Object handler, RequestContext request) {
        Object resolvedHandler = handler;
        if (handler instanceof HandlerWrapper) {
            HandlerWrapper wrapper = (HandlerWrapper)handler;
            resolvedHandler = wrapper.getRawHandler();
        }
        if (resolvedHandler instanceof CorsConfigurationSource) {
            CorsConfigurationSource configSource = (CorsConfigurationSource)resolvedHandler;
            return configSource.getCorsConfiguration(request);
        }
        return null;
    }

    protected HandlerExecutionChain getCorsHandlerExecutionChain(RequestContext request, Object handler, @Nullable CorsConfiguration config) {
        if (request.isPreFlightRequest()) {
            ArrayList<HandlerInterceptor> interceptors = new ArrayList<HandlerInterceptor>();
            HandlerInterceptor[] interceptorsArr = this.getHandlerInterceptors(handler);
            if (interceptorsArr != null) {
                for (HandlerInterceptor interceptor : interceptorsArr) {
                    interceptors.add(interceptor);
                }
            }
            if (!this.interceptors.isEmpty()) {
                interceptors.addAll(this.interceptors);
            }
            return new HandlerExecutionChain(new PreFlightHandler(config), interceptors.isEmpty() ? null : interceptors.toArray(new HandlerInterceptor[interceptors.size()]));
        }
        return this.getHandlerExecutionChain(handler, new CorsInterceptor(config));
    }

    private class PreFlightHandler
    implements HttpRequestHandler,
    CorsConfigurationSource {
        @Nullable
        private final CorsConfiguration config;

        public PreFlightHandler(CorsConfiguration config) {
            this.config = config;
        }

        @Override
        public Object handleRequest(RequestContext request) throws Throwable {
            AbstractHandlerMapping.this.corsProcessor.process(this.config, request);
            return NONE_RETURN_VALUE;
        }

        @Override
        @Nullable
        public CorsConfiguration getCorsConfiguration(RequestContext request) {
            return this.config;
        }
    }

    private class CorsInterceptor
    implements HandlerInterceptor,
    CorsConfigurationSource {
        @Nullable
        private final CorsConfiguration config;

        public CorsInterceptor(CorsConfiguration config) {
            this.config = config;
        }

        @Override
        public boolean beforeProcess(RequestContext request, Object handler) throws Throwable {
            return AbstractHandlerMapping.this.corsProcessor.process(this.config, request);
        }

        @Override
        @Nullable
        public CorsConfiguration getCorsConfiguration(RequestContext request) {
            return this.config;
        }
    }
}

