/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.core.OrderedSupport;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.LogFormatUtils;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.HandlerExceptionHandler;
import infra.web.RequestContext;
import infra.web.util.DisconnectedClientHelper;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractHandlerExceptionHandler
extends OrderedSupport
implements HandlerExceptionHandler {
    protected static final String DISCONNECTED_CLIENT_LOG_CATEGORY = "infra.web.handler.DisconnectedClient";
    protected static final DisconnectedClientHelper disconnectedClientHelper = new DisconnectedClientHelper("infra.web.handler.DisconnectedClient");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private Set<?> mappedHandlers;
    @Nullable
    private Class<?>[] mappedHandlerClasses;
    @Nullable
    private Logger warnLogger;
    private boolean preventResponseCaching = false;
    @Nullable
    private Predicate<Object> mappedHandlerPredicate;

    public void setMappedHandlers(@Nullable Set<?> mappedHandlers) {
        this.mappedHandlers = mappedHandlers;
    }

    public void setMappedHandlerClasses(Class<?> ... mappedHandlerClasses) {
        this.mappedHandlerClasses = mappedHandlerClasses;
    }

    public void addMappedHandlerClass(Class<?> mappedHandlerClass) {
        Class[] classArray;
        if (this.mappedHandlerClasses != null) {
            classArray = (Class[])ObjectUtils.addObjectToArray((Object[])this.mappedHandlerClasses, mappedHandlerClass);
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = mappedHandlerClass;
        }
        this.mappedHandlerClasses = classArray;
    }

    @Nullable
    protected Class<?>[] getMappedHandlerClasses() {
        return this.mappedHandlerClasses;
    }

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = StringUtils.isNotEmpty((CharSequence)loggerName) ? LoggerFactory.getLogger((String)loggerName) : null;
    }

    public void setPreventResponseCaching(boolean preventResponseCaching) {
        this.preventResponseCaching = preventResponseCaching;
    }

    public void setMappedHandlerPredicate(Predicate<Object> predicate) {
        this.mappedHandlerPredicate = this.mappedHandlerPredicate != null ? this.mappedHandlerPredicate.and(predicate) : predicate;
    }

    @Override
    @Nullable
    public Object handleException(RequestContext context, Throwable ex, @Nullable Object handler) throws Exception {
        if (this.shouldApplyTo(context, handler)) {
            this.prepareResponse(ex, context);
            Object result = this.handleInternal(context, handler, ex);
            if (result != null && result != NONE_RETURN_VALUE && !disconnectedClientHelper.checkAndLogClientDisconnectedException(ex)) {
                if (this.logger.isDebugEnabled() && (this.warnLogger == null || !this.warnLogger.isWarnEnabled())) {
                    this.logger.debug(this.buildLogMessage(ex, context) + " to " + result);
                }
                this.logException(ex, context);
            }
            return result;
        }
        return null;
    }

    protected boolean shouldApplyTo(RequestContext request, @Nullable Object handler) {
        if (this.mappedHandlerPredicate != null) {
            return this.mappedHandlerPredicate.test(handler);
        }
        if (handler != null) {
            if (this.mappedHandlers != null && this.mappedHandlers.contains(handler)) {
                return true;
            }
            if (this.mappedHandlerClasses != null) {
                for (Class<?> handlerClass : this.mappedHandlerClasses) {
                    if (!handlerClass.isInstance(handler)) continue;
                    return true;
                }
            }
        }
        return !this.hasHandlerMappings();
    }

    protected boolean hasHandlerMappings() {
        return this.mappedHandlers != null || this.mappedHandlerClasses != null || this.mappedHandlerPredicate != null;
    }

    protected void logException(Throwable ex, RequestContext request) {
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn(this.buildLogMessage(ex, request));
        }
    }

    protected String buildLogMessage(Throwable ex, RequestContext request) {
        return "Resolved [%s]".formatted(LogFormatUtils.formatValue((Object)ex, (int)-1, (boolean)true));
    }

    protected void logResultedInException(Throwable target, Throwable handlerException) {
        this.logger.warn("Failure while trying to resolve exception [{}]", (Object)target.getClass().getName(), (Object)handlerException);
    }

    protected void prepareResponse(Throwable ex, RequestContext response) {
        if (this.preventResponseCaching) {
            this.preventCaching(response);
        }
    }

    protected void preventCaching(RequestContext response) {
        response.addHeader("Cache-Control", "no-store");
    }

    @Nullable
    protected abstract Object handleInternal(RequestContext var1, @Nullable Object var2, Throwable var3) throws Exception;
}

