/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler;

import infra.beans.BeansException;
import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.context.ApplicationContext;
import infra.context.ApplicationContextException;
import infra.util.ObjectUtils;
import infra.web.handler.AbstractUrlHandlerMapping;
import java.util.Set;

public abstract class AbstractDetectingUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    private boolean detectHandlersInAncestorContexts = false;

    public void setDetectHandlersInAncestorContexts(boolean detectHandlersInAncestorContexts) {
        this.detectHandlersInAncestorContexts = detectHandlersInAncestorContexts;
    }

    @Override
    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        ApplicationContext applicationContext = this.obtainApplicationContext();
        Set beanNames = this.detectHandlersInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)applicationContext, Object.class) : applicationContext.getBeanNamesForType(Object.class);
        for (String beanName : beanNames) {
            Object[] urls = this.determineUrlsForHandler(beanName);
            if (!ObjectUtils.isNotEmpty((Object[])urls)) continue;
            this.registerHandler((String[])urls, beanName);
        }
        if (this.mappingsLogger.isDebugEnabled()) {
            this.mappingsLogger.debug("{}  {}", (Object)this.formatMappingName(), this.getHandlerMap());
        } else if (this.logger.isDebugEnabled() && !this.getHandlerMap().isEmpty() || this.logger.isTraceEnabled()) {
            this.logger.debug("Detected {} mappings in {}", (Object)this.getHandlerMap().size(), (Object)this.formatMappingName());
        }
    }

    protected abstract String[] determineUrlsForHandler(String var1);
}

