/*
 * Decompiled with CFR 0.152.
 */
package infra.web.cors;

import infra.http.server.RequestPath;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.cors.CorsConfiguration;
import infra.web.cors.CorsConfigurationSource;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PathPatternParser;
import java.util.LinkedHashMap;
import java.util.Map;

public class UrlBasedCorsConfigurationSource
implements CorsConfigurationSource {
    private final Map<PathPattern, CorsConfiguration> corsConfigurations = new LinkedHashMap<PathPattern, CorsConfiguration>();
    private final PathPatternParser patternParser;

    public UrlBasedCorsConfigurationSource() {
        this(PathPatternParser.defaultInstance);
    }

    public UrlBasedCorsConfigurationSource(PathPatternParser parser) {
        Assert.notNull((Object)parser, (String)"PathPatternParser is required");
        this.patternParser = parser;
    }

    public void setCorsConfigurations(@Nullable Map<String, CorsConfiguration> corsConfigurations) {
        this.corsConfigurations.clear();
        if (corsConfigurations != null) {
            for (Map.Entry<String, CorsConfiguration> entry : corsConfigurations.entrySet()) {
                this.registerCorsConfiguration(entry.getKey(), entry.getValue());
            }
        }
    }

    public void registerCorsConfiguration(String pattern, CorsConfiguration config) {
        this.corsConfigurations.put(this.patternParser.parse(pattern), config);
    }

    public Map<PathPattern, CorsConfiguration> getCorsConfigurations() {
        return this.corsConfigurations;
    }

    @Override
    public CorsConfiguration getCorsConfiguration(RequestContext request) {
        RequestPath lookupPath = request.getRequestPath();
        for (Map.Entry<PathPattern, CorsConfiguration> entry : this.corsConfigurations.entrySet()) {
            if (!entry.getKey().matches(lookupPath)) continue;
            return entry.getValue();
        }
        return null;
    }
}

