/*
 * Decompiled with CFR 0.152.
 */
package infra.web.cors;

import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.lang.Constant;
import infra.lang.Modifiable;
import infra.lang.Nullable;
import infra.lang.Unmodifiable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.CollectionUtils;
import infra.web.RequestContext;
import infra.web.cors.CorsConfiguration;
import infra.web.cors.CorsProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultCorsProcessor
implements CorsProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultCorsProcessor.class);
    static final String ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK = "Access-Control-Request-Private-Network";
    static final String ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK = "Access-Control-Allow-Private-Network";

    @Override
    public boolean process(@Nullable CorsConfiguration config, RequestContext context) throws IOException {
        HttpHeaders responseHeaders = context.responseHeaders();
        List<String> varyHeaders = responseHeaders.getVary();
        if (!varyHeaders.contains("Origin")) {
            responseHeaders.add("Vary", "Origin");
        }
        if (!varyHeaders.contains("Access-Control-Request-Method")) {
            responseHeaders.add("Vary", "Access-Control-Request-Method");
        }
        if (!varyHeaders.contains("Access-Control-Request-Headers")) {
            responseHeaders.add("Vary", "Access-Control-Request-Headers");
        }
        try {
            if (!context.isCorsRequest()) {
                return true;
            }
        }
        catch (IllegalArgumentException ex) {
            log.debug("Reject: origin is malformed");
            this.rejectRequest(context);
            return false;
        }
        if (responseHeaders.containsKey("Access-Control-Allow-Origin")) {
            log.trace("Skip: response already contains \"Access-Control-Allow-Origin\"");
            return true;
        }
        boolean preFlightRequest = context.isPreFlightRequest();
        if (config == null) {
            if (preFlightRequest) {
                this.rejectRequest(context);
                return false;
            }
            return true;
        }
        return this.handleInternal(context, config, preFlightRequest);
    }

    protected void rejectRequest(RequestContext context) throws IOException {
        context.setStatus(HttpStatus.FORBIDDEN);
        context.getOutputStream().write("Invalid CORS request".getBytes(Constant.DEFAULT_CHARSET));
        context.flush();
    }

    protected boolean handleInternal(RequestContext context, CorsConfiguration config, boolean preFlightRequest) throws IOException {
        String requestOrigin = context.requestHeaders().getOrigin();
        String allowOrigin = this.checkOrigin(config, requestOrigin);
        if (allowOrigin == null) {
            log.debug("Reject: '{}' origin is not allowed", (Object)requestOrigin);
            this.rejectRequest(context);
            return false;
        }
        HttpMethod requestMethod = this.getMethodToUse(context, preFlightRequest);
        List<HttpMethod> allowMethods = this.checkMethods(config, requestMethod);
        if (allowMethods == null) {
            log.debug("Reject: HTTP '{}' is not allowed", (Object)requestMethod);
            this.rejectRequest(context);
            return false;
        }
        List<String> requestHeaders = this.getHeadersToUse(context, preFlightRequest);
        List<String> allowHeaders = this.checkHeaders(config, requestHeaders);
        if (preFlightRequest && allowHeaders == null) {
            log.debug("Reject: headers '{}' are not allowed", requestHeaders);
            this.rejectRequest(context);
            return false;
        }
        HttpHeaders responseHeaders = context.responseHeaders();
        responseHeaders.setAccessControlAllowOrigin(allowOrigin);
        if (preFlightRequest) {
            responseHeaders.setAccessControlAllowMethods(allowMethods);
        }
        if (preFlightRequest && !allowHeaders.isEmpty()) {
            responseHeaders.setAccessControlAllowHeaders(allowHeaders);
        }
        if (CollectionUtils.isNotEmpty(config.getExposedHeaders())) {
            responseHeaders.setAccessControlExposeHeaders(config.getExposedHeaders());
        }
        if (Boolean.TRUE.equals(config.getAllowCredentials())) {
            responseHeaders.setAccessControlAllowCredentials(Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(config.getAllowPrivateNetwork()) && Boolean.parseBoolean(context.getHeaders().getFirst(ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK))) {
            responseHeaders.set(ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, Boolean.toString(true));
        }
        if (preFlightRequest && config.getMaxAge() != null) {
            responseHeaders.setAccessControlMaxAge(config.getMaxAge());
        }
        context.flush();
        return true;
    }

    @Nullable
    protected String checkOrigin(CorsConfiguration config, @Nullable String requestOrigin) {
        return config.checkOrigin(requestOrigin);
    }

    @Nullable
    @Unmodifiable
    protected List<HttpMethod> checkMethods(CorsConfiguration config, @Nullable HttpMethod method) {
        return config.checkHttpMethod(method);
    }

    @Nullable
    private HttpMethod getMethodToUse(RequestContext request, boolean isPreFlight) {
        return isPreFlight ? request.getHeaders().getAccessControlRequestMethod() : request.getMethod();
    }

    @Nullable
    @Modifiable
    protected List<String> checkHeaders(CorsConfiguration config, List<String> requestHeaders) {
        return config.checkHeaders(requestHeaders);
    }

    private List<String> getHeadersToUse(RequestContext context, boolean isPreFlight) {
        if (isPreFlight) {
            return context.requestHeaders().getAccessControlRequestHeaders();
        }
        return new ArrayList<String>(context.requestHeaders().keySet());
    }
}

