/*
 * Decompiled with CFR 0.152.
 */
package infra.web.cors;

import infra.lang.Assert;
import infra.web.HandlerInterceptor;
import infra.web.RequestContext;
import infra.web.cors.CorsConfiguration;
import infra.web.cors.CorsConfigurationSource;
import infra.web.cors.CorsProcessor;
import infra.web.cors.DefaultCorsProcessor;

public class CorsInterceptor
implements HandlerInterceptor {
    private final CorsConfigurationSource configSource;
    private CorsProcessor processor = new DefaultCorsProcessor();

    public CorsInterceptor(CorsConfigurationSource configSource) {
        Assert.notNull((Object)configSource, (String)"CorsConfigurationSource is required");
        this.configSource = configSource;
    }

    public void setCorsProcessor(CorsProcessor processor) {
        Assert.notNull((Object)processor, (String)"CorsProcessor is required");
        this.processor = processor;
    }

    @Override
    public boolean beforeProcess(RequestContext request, Object handler) throws Throwable {
        CorsConfiguration corsConfiguration = this.configSource.getCorsConfiguration(request);
        return this.processor.process(corsConfiguration, request) && !request.isPreFlightRequest();
    }
}

