/*
 * Decompiled with CFR 0.152.
 */
package infra.web.context.support;

import infra.beans.factory.BeanFactory;
import infra.lang.Nullable;
import infra.session.WebSession;
import infra.session.WebSessionAttributeListener;
import infra.web.RequestContext;
import infra.web.RequestContextHolder;
import infra.web.context.support.AbstractRequestContextScope;
import infra.web.context.support.DestructionCallbackBindingListener;
import infra.web.context.support.SessionManagerDiscover;
import infra.web.util.WebUtils;
import java.util.Objects;
import java.util.function.Supplier;

public class SessionScope
extends AbstractRequestContextScope<WebSession> {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = SessionScope.class.getName() + ".DESTRUCTION_CALLBACK.";
    private final SessionManagerDiscover sessionManagerDiscover;

    public SessionScope(BeanFactory beanFactory) {
        this.sessionManagerDiscover = new SessionManagerDiscover(beanFactory);
    }

    public String getConversationId() {
        RequestContext context = RequestContextHolder.getRequired();
        WebSession session = this.getSession(context, false);
        if (session != null) {
            return session.getId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, Supplier<?> objectFactory) {
        Object sessionMutex;
        RequestContext context = RequestContextHolder.getRequired();
        WebSession session = this.getSession(context);
        Object object = sessionMutex = WebUtils.getSessionMutex(session);
        synchronized (object) {
            return this.doGetBean(session, name, objectFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object remove(String name) {
        RequestContext context = RequestContextHolder.getRequired();
        WebSession session = this.getSession(context);
        if (session != null) {
            Object sessionMutex;
            Object object = sessionMutex = WebUtils.getSessionMutex(session);
            synchronized (object) {
                return this.remove(session, name);
            }
        }
        return null;
    }

    private WebSession getSession(RequestContext context) {
        return this.getSession(context, true);
    }

    private WebSession getSession(RequestContext request, boolean create) {
        return this.sessionManagerDiscover.obtain(request).getSession(request, create);
    }

    @Override
    protected void setAttribute(WebSession context, String beanName, Object scopedObject) {
        context.setAttribute(beanName, scopedObject);
    }

    @Override
    protected Object getAttribute(WebSession context, String beanName) {
        return context.getAttribute(beanName);
    }

    @Override
    protected void removeAttribute(WebSession context, String name) {
        context.removeAttribute(name);
    }

    @Nullable
    public Object resolveContextualObject(String key) {
        RequestContext context;
        if ("request".equals(key)) {
            return RequestContextHolder.get();
        }
        if ("session".equals(key) && (context = RequestContextHolder.get()) != null) {
            return this.getSession(context, false);
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        RequestContext context = RequestContextHolder.getRequired();
        WebSession session = this.getSession(context);
        session.setAttribute(SessionScope.getDestructionCallbackName(name), new DestructionCallbackBindingListener(callback));
    }

    private static String getDestructionCallbackName(String name) {
        return DESTRUCTION_CALLBACK_NAME_PREFIX + name;
    }

    public static WebSessionAttributeListener createDestructionCallback() {
        return new DestructionCallback();
    }

    static final class DestructionCallback
    implements WebSessionAttributeListener {
        DestructionCallback() {
        }

        @Override
        public void attributeRemoved(WebSession session, String attributeName, @Nullable Object value) {
            String destructionName = SessionScope.getDestructionCallbackName(attributeName);
            if (!Objects.equals(destructionName, attributeName)) {
                session.removeAttribute(destructionName);
            }
        }
    }
}

