/*
 * Decompiled with CFR 0.152.
 */
package infra.web.context.support;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;

public class SessionManagerDiscover {
    private final BeanFactory beanFactory;
    @Nullable
    private volatile SessionManager sessionManager;
    private volatile boolean managerLoaded = false;

    public SessionManagerDiscover(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory is required");
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SessionManager find() {
        SessionManager sessionManager = this.sessionManager;
        if (sessionManager == null) {
            SessionManagerDiscover sessionManagerDiscover = this;
            synchronized (sessionManagerDiscover) {
                sessionManager = this.sessionManager;
                if (sessionManager == null) {
                    if (this.managerLoaded) {
                        return null;
                    }
                    sessionManager = (SessionManager)BeanFactoryUtils.find((BeanFactory)this.beanFactory, (String)"webSessionManager", SessionManager.class);
                    if (sessionManager == null) {
                        sessionManager = (SessionManager)BeanFactoryUtils.find((BeanFactory)this.beanFactory, SessionManager.class);
                    }
                    this.sessionManager = sessionManager;
                    this.managerLoaded = true;
                }
            }
        }
        return sessionManager;
    }

    public SessionManager obtain(RequestContext request) {
        SessionManager sessionManager = this.find();
        if (sessionManager == null && (sessionManager = RequestContextUtils.getSessionManager(request)) == null) {
            throw new IllegalStateException("No SessionManager in context");
        }
        return sessionManager;
    }
}

