/*
 * Decompiled with CFR 0.152.
 */
package infra.web.context.support;

import infra.context.ApplicationEvent;
import infra.context.ApplicationEventPublisher;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestCompletedListener;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.context.support.RequestHandledEvent;

public class RequestHandledEventPublisher
implements RequestCompletedListener {
    protected final ApplicationEventPublisher eventPublisher;

    public RequestHandledEventPublisher(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"ApplicationEventPublisher is required");
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void requestCompleted(RequestContext request, @Nullable Throwable notHandled) {
        ApplicationEvent event = this.getRequestHandledEvent(request, notHandled);
        this.eventPublisher.publishEvent(event);
    }

    protected ApplicationEvent getRequestHandledEvent(RequestContext request, @Nullable Throwable notHandled) {
        return new RequestHandledEvent(this, request.getRequestURI(), request.getRemoteAddress(), request.getMethodValue(), RequestContextUtils.getSessionId(request), request.getRequestProcessingTime(), notHandled, request.getStatus());
    }
}

