/*
 * Decompiled with CFR 0.152.
 */
package infra.web.context.support;

import infra.context.ApplicationEvent;
import infra.lang.Nullable;

public class RequestHandledEvent
extends ApplicationEvent {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String sessionId;
    private final long processingTimeMillis;
    @Nullable
    private final Throwable notHandled;
    private final String requestUrl;
    private final String clientAddress;
    private final String method;
    private final int statusCode;

    public RequestHandledEvent(Object source, String requestUrl, String clientAddress, String method, @Nullable String sessionId, long processingTimeMillis, @Nullable Throwable notHandled, int statusCode) {
        super(source);
        this.method = method;
        this.sessionId = sessionId;
        this.statusCode = statusCode;
        this.requestUrl = requestUrl;
        this.notHandled = notHandled;
        this.clientAddress = clientAddress;
        this.processingTimeMillis = processingTimeMillis;
    }

    public long getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    public boolean wasFailure() {
        return this.notHandled != null;
    }

    @Nullable
    public Throwable getFailureCause() {
        return this.notHandled;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getMethod() {
        return this.method;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getShortDescription() {
        return "url=[%s]; client=[%s]; session=[%s]; ".formatted(this.getRequestUrl(), this.getClientAddress(), this.sessionId);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("url=[").append(this.getRequestUrl()).append("]; ");
        sb.append("client=[").append(this.getClientAddress()).append("]; ");
        sb.append("method=[").append(this.getMethod()).append("]; ");
        sb.append("session=[").append(this.sessionId).append("]; ");
        sb.append("time=[").append(this.processingTimeMillis).append("ms]; ");
        sb.append("status=[");
        if (!this.wasFailure()) {
            sb.append("OK");
        } else {
            sb.append("failed: ").append(this.notHandled);
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString() {
        return "RequestHandledEvent: " + this.getDescription();
    }
}

