/*
 * Decompiled with CFR 0.152.
 */
package infra.web.context.support;

import infra.beans.factory.config.Scope;
import java.util.function.Supplier;

public abstract class AbstractRequestContextScope<T>
implements Scope {
    protected final Object doGetBean(T context, String beanName, Supplier<?> objectFactory) {
        Object scopedObject = this.getAttribute(context, beanName);
        if (scopedObject == null) {
            scopedObject = objectFactory.get();
            this.setAttribute(context, beanName, scopedObject);
            Object retrievedObject = this.getAttribute(context, beanName);
            if (retrievedObject != null) {
                scopedObject = retrievedObject;
            }
        }
        return scopedObject;
    }

    protected Object remove(T context, String name) {
        Object scopedObject = this.getAttribute(context, name);
        if (scopedObject != null) {
            this.removeAttribute(context, name);
            return scopedObject;
        }
        return null;
    }

    protected abstract void setAttribute(T var1, String var2, Object var3);

    protected abstract Object getAttribute(T var1, String var2);

    protected abstract void removeAttribute(T var1, String var2);
}

