/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config.format;

import infra.format.AnnotationFormatterFactory;
import infra.format.Formatter;
import infra.format.FormatterRegistry;
import infra.format.datetime.DateFormatter;
import infra.format.datetime.DateFormatterRegistrar;
import infra.format.datetime.standard.DateTimeFormatterRegistrar;
import infra.format.number.NumberFormatAnnotationFormatterFactory;
import infra.format.number.money.CurrencyUnitFormatter;
import infra.format.number.money.Jsr354NumberFormatAnnotationFormatterFactory;
import infra.format.number.money.MonetaryAmountFormatter;
import infra.format.support.DefaultFormattingConversionService;
import infra.web.config.format.DateTimeFormatters;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class WebConversionService
extends DefaultFormattingConversionService {
    public WebConversionService(DateTimeFormatters dateTimeFormatters) {
        super(false);
        if (dateTimeFormatters.isCustomized()) {
            this.addFormatters(dateTimeFormatters);
        } else {
            WebConversionService.addDefaultFormatters((FormatterRegistry)this);
        }
    }

    private void addFormatters(DateTimeFormatters dateTimeFormatters) {
        this.addFormatterForFieldAnnotation((AnnotationFormatterFactory)new NumberFormatAnnotationFormatterFactory());
        if (jsr354Present) {
            this.addFormatter((Formatter)new CurrencyUnitFormatter());
            this.addFormatter((Formatter)new MonetaryAmountFormatter());
            this.addFormatterForFieldAnnotation((AnnotationFormatterFactory)new Jsr354NumberFormatAnnotationFormatterFactory());
        }
        this.registerJsr310(dateTimeFormatters);
        this.registerJavaDate(dateTimeFormatters);
    }

    private void registerJsr310(DateTimeFormatters dateTimeFormatters) {
        DateTimeFormatterRegistrar dateTime = new DateTimeFormatterRegistrar();
        this.configure(dateTimeFormatters::getDateFormatter, arg_0 -> ((DateTimeFormatterRegistrar)dateTime).setDateFormatter(arg_0));
        this.configure(dateTimeFormatters::getTimeFormatter, arg_0 -> ((DateTimeFormatterRegistrar)dateTime).setTimeFormatter(arg_0));
        this.configure(dateTimeFormatters::getDateTimeFormatter, arg_0 -> ((DateTimeFormatterRegistrar)dateTime).setDateTimeFormatter(arg_0));
        dateTime.registerFormatters((FormatterRegistry)this);
    }

    private void configure(Supplier<DateTimeFormatter> supplier, Consumer<DateTimeFormatter> consumer) {
        DateTimeFormatter formatter = supplier.get();
        if (formatter != null) {
            consumer.accept(formatter);
        }
    }

    private void registerJavaDate(DateTimeFormatters dateTimeFormatters) {
        DateFormatterRegistrar dateFormatterRegistrar = new DateFormatterRegistrar();
        String datePattern = dateTimeFormatters.getDatePattern();
        if (datePattern != null) {
            DateFormatter dateFormatter = new DateFormatter(datePattern);
            dateFormatterRegistrar.setFormatter(dateFormatter);
        }
        dateFormatterRegistrar.registerFormatters((FormatterRegistry)this);
    }
}

