/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.BeanInitializationException;
import infra.beans.factory.annotation.DisableAllDependencyInjection;
import infra.beans.factory.annotation.Qualifier;
import infra.context.ApplicationContext;
import infra.context.MessageSource;
import infra.context.annotation.Role;
import infra.context.condition.ConditionalOnMissingBean;
import infra.context.support.ApplicationObjectSupport;
import infra.core.conversion.ConversionService;
import infra.format.FormatterRegistry;
import infra.format.support.DefaultFormattingConversionService;
import infra.format.support.FormattingConversionService;
import infra.http.MediaType;
import infra.http.converter.AllEncompassingFormHttpMessageConverter;
import infra.http.converter.ByteArrayHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.ResourceHttpMessageConverter;
import infra.http.converter.ResourceRegionHttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import infra.http.converter.feed.AtomFeedHttpMessageConverter;
import infra.http.converter.feed.RssChannelHttpMessageConverter;
import infra.http.converter.json.GsonHttpMessageConverter;
import infra.http.converter.json.Jackson2ObjectMapperBuilder;
import infra.http.converter.json.JsonbHttpMessageConverter;
import infra.http.converter.json.MappingJackson2HttpMessageConverter;
import infra.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import infra.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import infra.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import infra.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.stereotype.Component;
import infra.util.ClassUtils;
import infra.util.CollectionUtils;
import infra.validation.Errors;
import infra.validation.MessageCodesResolver;
import infra.validation.Validator;
import infra.validation.beanvalidation.OptionalValidatorFactoryBean;
import infra.web.ErrorResponse;
import infra.web.HandlerExceptionHandler;
import infra.web.HandlerMapping;
import infra.web.LocaleResolver;
import infra.web.NotFoundHandler;
import infra.web.RedirectModelManager;
import infra.web.accept.ContentNegotiationManager;
import infra.web.async.WebAsyncManagerFactory;
import infra.web.bind.resolver.ParameterResolvingRegistry;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.bind.support.ConfigurableWebBindingInitializer;
import infra.web.bind.support.WebBindingInitializer;
import infra.web.config.AsyncSupportConfigurer;
import infra.web.config.ContentNegotiationConfigurer;
import infra.web.config.CorsRegistry;
import infra.web.config.InterceptorRegistry;
import infra.web.config.PathMatchConfigurer;
import infra.web.config.ResourceHandlerRegistry;
import infra.web.config.ViewControllerRegistry;
import infra.web.config.ViewResolverRegistry;
import infra.web.cors.CorsConfiguration;
import infra.web.handler.AbstractHandlerMapping;
import infra.web.handler.BeanNameUrlHandlerMapping;
import infra.web.handler.CompositeHandlerExceptionHandler;
import infra.web.handler.ResponseStatusExceptionHandler;
import infra.web.handler.ReturnValueHandlerManager;
import infra.web.handler.SimpleHandlerExceptionHandler;
import infra.web.handler.SimpleUrlHandlerMapping;
import infra.web.handler.function.support.HandlerFunctionAdapter;
import infra.web.handler.function.support.RouterFunctionMapping;
import infra.web.handler.method.ControllerAdviceBean;
import infra.web.handler.method.ExceptionHandlerAnnotationExceptionHandler;
import infra.web.handler.method.JsonViewRequestBodyAdvice;
import infra.web.handler.method.JsonViewResponseBodyAdvice;
import infra.web.handler.method.RequestBodyAdvice;
import infra.web.handler.method.RequestMappingHandlerAdapter;
import infra.web.handler.method.RequestMappingHandlerMapping;
import infra.web.handler.method.ResponseBodyAdvice;
import infra.web.handler.method.support.CompositeUriComponentsContributor;
import infra.web.i18n.AcceptHeaderLocaleResolver;
import infra.web.view.UrlBasedViewResolver;
import infra.web.view.ViewResolver;
import infra.web.view.ViewResolverComposite;
import infra.web.view.ViewReturnValueHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DisableAllDependencyInjection
public class WebMvcConfigurationSupport
extends ApplicationObjectSupport {
    private static final boolean gsonPresent = WebMvcConfigurationSupport.isPresent("com.google.gson.Gson");
    private static final boolean jsonbPresent = WebMvcConfigurationSupport.isPresent("jakarta.json.bind.Jsonb");
    private static final boolean jaxb2Present = WebMvcConfigurationSupport.isPresent("jakarta.xml.bind.Binder");
    private static final boolean romePresent = WebMvcConfigurationSupport.isPresent("com.rometools.rome.feed.WireFeed");
    private static final boolean jackson2Present = WebMvcConfigurationSupport.isPresent("com.fasterxml.jackson.databind.ObjectMapper") && WebMvcConfigurationSupport.isPresent("com.fasterxml.jackson.core.JsonGenerator");
    private static final boolean jackson2XmlPresent = WebMvcConfigurationSupport.isPresent("com.fasterxml.jackson.dataformat.xml.XmlMapper");
    private static final boolean jackson2CborPresent = WebMvcConfigurationSupport.isPresent("com.fasterxml.jackson.dataformat.cbor.CBORFactory");
    private static final boolean jackson2YamlPresent = WebMvcConfigurationSupport.isPresent("com.fasterxml.jackson.dataformat.yaml.YAMLFactory");
    private static final boolean jackson2SmilePresent = WebMvcConfigurationSupport.isPresent("com.fasterxml.jackson.dataformat.smile.SmileFactory");
    private final List<Object> requestResponseBodyAdvice = new ArrayList<Object>();
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    @Nullable
    private PathMatchConfigurer pathMatchConfigurer;
    @Nullable
    private List<HttpMessageConverter<?>> messageConverters;
    @Nullable
    private Map<String, CorsConfiguration> corsConfigurations;
    @Nullable
    private List<Object> interceptors;
    @Nullable
    private AsyncSupportConfigurer asyncSupportConfigurer;
    @Nullable
    private List<ErrorResponse.Interceptor> errorResponseInterceptors;

    protected void initApplicationContext() {
        this.initControllerAdviceCache();
    }

    private void initControllerAdviceCache() {
        List<ControllerAdviceBean> adviceBeans = ControllerAdviceBean.findAnnotatedBeans(this.obtainApplicationContext(), RequestBodyAdvice.class, ResponseBodyAdvice.class);
        if (!adviceBeans.isEmpty()) {
            this.requestResponseBodyAdvice.addAll(0, adviceBeans);
        }
        if (jackson2Present) {
            this.requestResponseBodyAdvice.add(new JsonViewRequestBodyAdvice());
            this.requestResponseBodyAdvice.add(new JsonViewResponseBodyAdvice());
        }
    }

    public final List<HttpMessageConverter<?>> getMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            this.configureMessageConverters(this.messageConverters);
            if (this.messageConverters.isEmpty()) {
                this.addDefaultHttpMessageConverters(this.messageConverters);
            }
            this.extendMessageConverters(this.messageConverters);
        }
        return this.messageConverters;
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected final void addDefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Jackson2ObjectMapperBuilder builder;
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter());
        messageConverters.add(new ResourceHttpMessageConverter());
        messageConverters.add(new ResourceRegionHttpMessageConverter());
        messageConverters.add(new AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add(new AtomFeedHttpMessageConverter());
            messageConverters.add(new RssChannelHttpMessageConverter());
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        if (jackson2XmlPresent) {
            builder = Jackson2ObjectMapperBuilder.xml();
            if (applicationContext != null) {
                builder.applicationContext(applicationContext);
            }
            messageConverters.add(new MappingJackson2XmlHttpMessageConverter((ObjectMapper)builder.build()));
        } else if (jaxb2Present) {
            messageConverters.add(new Jaxb2RootElementHttpMessageConverter());
        }
        if (jackson2Present) {
            builder = Jackson2ObjectMapperBuilder.json();
            if (applicationContext != null) {
                builder.applicationContext(applicationContext);
            }
            messageConverters.add(new MappingJackson2HttpMessageConverter((ObjectMapper)builder.build()));
        } else if (gsonPresent) {
            messageConverters.add(new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            messageConverters.add(new JsonbHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            builder = Jackson2ObjectMapperBuilder.smile();
            if (applicationContext != null) {
                builder.applicationContext(applicationContext);
            }
            messageConverters.add(new MappingJackson2SmileHttpMessageConverter((ObjectMapper)builder.build()));
        }
        if (jackson2CborPresent) {
            builder = Jackson2ObjectMapperBuilder.cbor();
            if (applicationContext != null) {
                builder.applicationContext(applicationContext);
            }
            messageConverters.add(new MappingJackson2CborHttpMessageConverter((ObjectMapper)builder.build()));
        }
        if (jackson2YamlPresent) {
            builder = Jackson2ObjectMapperBuilder.yaml();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add(new MappingJackson2YamlHttpMessageConverter((ObjectMapper)builder.build()));
        }
    }

    @Component
    @ConditionalOnMissingBean
    @Role(value=2)
    public WebAsyncManagerFactory webAsyncManagerFactory() {
        WebAsyncManagerFactory factory = new WebAsyncManagerFactory();
        AsyncSupportConfigurer configurer = this.getAsyncSupportConfigurer();
        if (configurer.taskExecutor != null) {
            factory.setTaskExecutor(configurer.taskExecutor);
        }
        factory.setAsyncRequestTimeout(configurer.timeout);
        factory.setCallableInterceptors(configurer.callableInterceptors);
        factory.setDeferredResultInterceptors(configurer.deferredResultInterceptors);
        return factory;
    }

    @Component
    @Role(value=2)
    @ConditionalOnMissingBean(value={ContentNegotiationManager.class})
    public ContentNegotiationManager mvcContentNegotiationManager() {
        if (this.contentNegotiationManager == null) {
            ContentNegotiationConfigurer configurer = this.createNegotiationConfigurer();
            configurer.mediaTypes(this.getDefaultMediaTypes());
            this.configureContentNegotiation(configurer);
            this.contentNegotiationManager = configurer.buildContentNegotiationManager();
        }
        return this.contentNegotiationManager;
    }

    private ContentNegotiationConfigurer createNegotiationConfigurer() {
        return new ContentNegotiationConfigurer();
    }

    protected Map<String, MediaType> getDefaultMediaTypes() {
        HashMap<String, MediaType> map = new HashMap<String, MediaType>(4);
        if (romePresent) {
            map.put("atom", MediaType.APPLICATION_ATOM_XML);
            map.put("rss", MediaType.APPLICATION_RSS_XML);
        }
        if (jaxb2Present || jackson2XmlPresent) {
            map.put("xml", MediaType.APPLICATION_XML);
        }
        if (jackson2Present || gsonPresent || jsonbPresent) {
            map.put("json", MediaType.APPLICATION_JSON);
        }
        if (jackson2SmilePresent) {
            map.put("smile", MediaType.valueOf("application/x-jackson-smile"));
        }
        if (jackson2CborPresent) {
            map.put("cbor", MediaType.APPLICATION_CBOR);
        }
        if (jackson2YamlPresent) {
            map.put("yaml", MediaType.APPLICATION_YAML);
        }
        return map;
    }

    protected void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    protected PathMatchConfigurer getPathMatchConfigurer() {
        if (this.pathMatchConfigurer == null) {
            this.pathMatchConfigurer = new PathMatchConfigurer();
            this.configurePathMatch(this.pathMatchConfigurer);
        }
        return this.pathMatchConfigurer;
    }

    protected void configurePathMatch(PathMatchConfigurer configurer) {
    }

    @Nullable
    @Component
    @Role(value=2)
    public ViewResolver mvcViewResolver(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager) {
        Set names;
        ViewResolverRegistry registry = new ViewResolverRegistry(contentNegotiationManager, this.applicationContext);
        this.configureViewResolvers(registry);
        ArrayList<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(registry.getViewResolvers());
        if (this.applicationContext != null && (names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)this.applicationContext, ViewResolver.class, (boolean)true, (boolean)false)).size() == 1) {
            viewResolvers.add(new UrlBasedViewResolver());
            this.configureDefaultViewResolvers(viewResolvers);
        }
        if (viewResolvers.isEmpty()) {
            return null;
        }
        ViewResolverComposite composite = new ViewResolverComposite();
        composite.setOrder(registry.getOrder());
        composite.setViewResolvers(viewResolvers);
        return composite;
    }

    protected void configureDefaultViewResolvers(List<ViewResolver> viewResolvers) {
    }

    protected void configureViewResolvers(ViewResolverRegistry registry) {
    }

    @Component
    @ConditionalOnMissingBean(name={"webLocaleResolver"})
    public LocaleResolver webLocaleResolver() {
        return new AcceptHeaderLocaleResolver();
    }

    @Component
    @Role(value=2)
    @ConditionalOnMissingBean(value={ViewReturnValueHandler.class})
    public ViewReturnValueHandler viewReturnValueHandler(@Qualifier(value="webLocaleResolver") LocaleResolver localeResolver, List<ViewResolver> viewResolvers) {
        ViewResolver viewResolver;
        if (viewResolvers.size() == 1) {
            viewResolver = (ViewResolver)CollectionUtils.firstElement(viewResolvers);
            Assert.state((viewResolver != null ? 1 : 0) != 0, (String)"No ViewResolver");
        } else {
            ViewResolverComposite composite = new ViewResolverComposite();
            composite.setViewResolvers(viewResolvers);
            viewResolver = composite;
        }
        return new ViewReturnValueHandler(viewResolver, localeResolver);
    }

    @Component
    @Role(value=2)
    @ConditionalOnMissingBean(value={ReturnValueHandlerManager.class})
    public ReturnValueHandlerManager returnValueHandlerManager(ViewReturnValueHandler viewHandler, @Nullable RedirectModelManager redirectModelManager, @Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager) {
        ReturnValueHandlerManager manager = new ReturnValueHandlerManager(this.getMessageConverters());
        manager.setApplicationContext(this.applicationContext);
        manager.setRedirectModelManager(redirectModelManager);
        AsyncSupportConfigurer configurer = this.getAsyncSupportConfigurer();
        if (configurer.taskExecutor != null) {
            manager.setTaskExecutor(configurer.taskExecutor);
        }
        manager.setContentNegotiationManager(contentNegotiationManager);
        manager.setViewReturnValueHandler(viewHandler);
        manager.addRequestResponseBodyAdvice(this.requestResponseBodyAdvice);
        manager.registerDefaultHandlers();
        this.modifyReturnValueHandlerManager(manager);
        return manager;
    }

    protected void modifyReturnValueHandlerManager(ReturnValueHandlerManager manager) {
    }

    @Component
    @ConditionalOnMissingBean
    @Role(value=2)
    public ParameterResolvingRegistry parameterResolvingRegistry(ParameterResolvingStrategy[] strategies, @Nullable RedirectModelManager redirectModelManager, @Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager) {
        ParameterResolvingRegistry registry = new ParameterResolvingRegistry(this.getMessageConverters());
        registry.setApplicationContext(this.getApplicationContext());
        registry.setRedirectModelManager(redirectModelManager);
        registry.addRequestResponseBodyAdvice(this.requestResponseBodyAdvice);
        registry.setContentNegotiationManager(contentNegotiationManager);
        registry.registerDefaultStrategies();
        registry.addCustomizedStrategies(strategies);
        this.modifyParameterResolvingRegistry(registry);
        return registry;
    }

    protected void modifyParameterResolvingRegistry(ParameterResolvingRegistry registry) {
    }

    @Component
    @Role(value=2)
    public HandlerExceptionHandler handlerExceptionHandler(ParameterResolvingRegistry registry, @Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager) {
        ArrayList<HandlerExceptionHandler> handlers = new ArrayList<HandlerExceptionHandler>();
        this.configureExceptionHandlers(handlers);
        if (handlers.isEmpty()) {
            this.addDefaultHandlerExceptionHandlers(handlers, registry, contentNegotiationManager);
        }
        this.extendExceptionHandlers(handlers);
        CompositeHandlerExceptionHandler composite = new CompositeHandlerExceptionHandler();
        composite.setOrder(0);
        composite.setExceptionHandlers(handlers);
        return composite;
    }

    protected void configureExceptionHandlers(List<HandlerExceptionHandler> handlers) {
    }

    protected void extendExceptionHandlers(List<HandlerExceptionHandler> handlers) {
    }

    protected final void addDefaultHandlerExceptionHandlers(List<HandlerExceptionHandler> handlers, ParameterResolvingRegistry registry, ContentNegotiationManager contentNegotiationManager) {
        ExceptionHandlerAnnotationExceptionHandler handler = this.createAnnotationExceptionHandler();
        if (this.applicationContext != null) {
            handler.setApplicationContext(this.applicationContext);
        }
        handler.setContentNegotiationManager(contentNegotiationManager);
        handler.setParameterResolvingRegistry(registry);
        handler.afterPropertiesSet();
        handlers.add(handler);
        ResponseStatusExceptionHandler statusExceptionHandler = new ResponseStatusExceptionHandler();
        statusExceptionHandler.setMessageSource((MessageSource)this.applicationContext);
        handlers.add(statusExceptionHandler);
        handlers.add(new SimpleHandlerExceptionHandler());
    }

    protected ExceptionHandlerAnnotationExceptionHandler createAnnotationExceptionHandler() {
        return new ExceptionHandlerAnnotationExceptionHandler();
    }

    @Component
    @Role(value=2)
    @ConditionalOnMissingBean(value={RequestMappingHandlerMapping.class})
    public RequestMappingHandlerMapping requestMappingHandlerMapping(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager, ParameterResolvingRegistry parameterResolvingRegistry) {
        RequestMappingHandlerMapping mapping = this.createRequestMappingHandlerMapping();
        mapping.setOrder(0);
        mapping.setContentNegotiationManager(contentNegotiationManager);
        mapping.setResolvingRegistry(parameterResolvingRegistry);
        this.initHandlerMapping(mapping);
        PathMatchConfigurer pathConfig = this.getPathMatchConfigurer();
        if (pathConfig.getPathPrefixes() != null) {
            mapping.setPathPrefixes(pathConfig.getPathPrefixes());
        }
        return mapping;
    }

    protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        return new RequestMappingHandlerMapping();
    }

    @Component
    @Role(value=2)
    public BeanNameUrlHandlerMapping beanNameHandlerMapping() {
        BeanNameUrlHandlerMapping mapping = new BeanNameUrlHandlerMapping();
        mapping.setOrder(2);
        this.initHandlerMapping(mapping);
        return mapping;
    }

    @Component
    @Role(value=2)
    public RouterFunctionMapping routerFunctionMapping() {
        RouterFunctionMapping mapping = new RouterFunctionMapping();
        mapping.setOrder(3);
        mapping.setMessageConverters(this.getMessageConverters());
        this.initHandlerMapping(mapping);
        return mapping;
    }

    public void initHandlerMapping(@Nullable AbstractHandlerMapping mapping) {
        if (mapping != null) {
            Boolean useCaseSensitiveMatch;
            mapping.setInterceptors(this.getInterceptors());
            mapping.setCorsConfigurations(this.getCorsConfigurations());
            PathMatchConfigurer configurer = this.getPathMatchConfigurer();
            Boolean useTrailingSlashMatch = configurer.isUseTrailingSlashMatch();
            if (useTrailingSlashMatch != null) {
                mapping.setUseTrailingSlashMatch(useTrailingSlashMatch);
            }
            if ((useCaseSensitiveMatch = configurer.isUseCaseSensitiveMatch()) != null) {
                mapping.setUseCaseSensitiveMatch(useCaseSensitiveMatch);
            }
        }
    }

    @Nullable
    @Component
    @Role(value=2)
    public HandlerMapping resourceHandlerMapping(@Nullable NotFoundHandler notFoundHandler, @Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager) {
        ApplicationContext context = this.obtainApplicationContext();
        ResourceHandlerRegistry registry = new ResourceHandlerRegistry(context, contentNegotiationManager);
        registry.setNotFoundHandler(notFoundHandler);
        this.addResourceHandlers(registry);
        SimpleUrlHandlerMapping handlerMapping = registry.getHandlerMapping();
        this.initHandlerMapping(handlerMapping);
        return handlerMapping;
    }

    @Component
    @Nullable
    @Role(value=2)
    public HandlerMapping viewControllerHandlerMapping() {
        ViewControllerRegistry registry = new ViewControllerRegistry(this.applicationContext);
        this.addViewControllers(registry);
        SimpleUrlHandlerMapping mapping = registry.buildHandlerMapping();
        this.initHandlerMapping(mapping);
        return mapping;
    }

    protected void addViewControllers(ViewControllerRegistry registry) {
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    protected final Map<String, CorsConfiguration> getCorsConfigurations() {
        if (this.corsConfigurations == null) {
            CorsRegistry registry = new CorsRegistry();
            this.addCorsMappings(registry);
            this.corsConfigurations = registry.getCorsConfigurations();
        }
        return this.corsConfigurations;
    }

    protected void addCorsMappings(CorsRegistry registry) {
    }

    protected final Object[] getInterceptors() {
        if (this.interceptors == null) {
            InterceptorRegistry registry = new InterceptorRegistry();
            this.addInterceptors(registry);
            this.interceptors = registry.getInterceptors();
        }
        return this.interceptors.toArray();
    }

    protected void addInterceptors(InterceptorRegistry registry) {
    }

    @Component
    @Role(value=2)
    public FormattingConversionService mvcConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        this.addFormatters((FormatterRegistry)conversionService);
        return conversionService;
    }

    protected void addFormatters(FormatterRegistry registry) {
    }

    @Component
    @Role(value=2)
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter(@Nullable SessionManager sessionManager, @Nullable RedirectModelManager redirectModelManager, @Nullable WebBindingInitializer webBindingInitializer, ParameterResolvingRegistry parameterResolvingRegistry, @Qualifier(value="mvcValidator") Validator validator, @Qualifier(value="mvcConversionService") FormattingConversionService conversionService) {
        RequestMappingHandlerAdapter adapter = this.createRequestMappingHandlerAdapter();
        adapter.setSessionManager(sessionManager);
        adapter.setRedirectModelManager(redirectModelManager);
        adapter.setResolvingRegistry(parameterResolvingRegistry);
        if (webBindingInitializer == null) {
            webBindingInitializer = this.getWebBindingInitializer(conversionService, validator);
        }
        adapter.setWebBindingInitializer(webBindingInitializer);
        return adapter;
    }

    protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
        return new RequestMappingHandlerAdapter();
    }

    @Component
    @Role(value=2)
    public HandlerFunctionAdapter handlerFunctionAdapter() {
        return new HandlerFunctionAdapter();
    }

    protected WebBindingInitializer getWebBindingInitializer(FormattingConversionService mvcConversionService, Validator mvcValidator) {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)mvcConversionService);
        initializer.setValidator(mvcValidator);
        MessageCodesResolver messageCodesResolver = this.getMessageCodesResolver();
        if (messageCodesResolver != null) {
            initializer.setMessageCodesResolver(messageCodesResolver);
        }
        return initializer;
    }

    @Component
    @Role(value=2)
    public Validator mvcValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (ClassUtils.isPresent((String)"jakarta.validation.Validator", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
                try {
                    validator = new OptionalValidatorFactoryBean();
                }
                catch (Throwable ex) {
                    throw new BeanInitializationException("Failed to create default validator", ex);
                }
            } else {
                validator = new NoOpValidator();
            }
        }
        return validator;
    }

    @Nullable
    protected MessageCodesResolver getMessageCodesResolver() {
        return null;
    }

    @Nullable
    protected Validator getValidator() {
        return null;
    }

    protected AsyncSupportConfigurer getAsyncSupportConfigurer() {
        if (this.asyncSupportConfigurer == null) {
            this.asyncSupportConfigurer = new AsyncSupportConfigurer();
            this.configureAsyncSupport(this.asyncSupportConfigurer);
        }
        return this.asyncSupportConfigurer;
    }

    protected void configureAsyncSupport(AsyncSupportConfigurer configurer) {
    }

    @Component
    @Role(value=2)
    public CompositeUriComponentsContributor mvcUriComponentsContributor(ParameterResolvingRegistry registry, @Qualifier(value="mvcConversionService") FormattingConversionService conversionService) {
        ArrayList<ParameterResolvingStrategy> strategies = new ArrayList<ParameterResolvingStrategy>(registry.getDefaultStrategies().getStrategies());
        strategies.addAll(registry.getCustomizedStrategies().getStrategies());
        return new CompositeUriComponentsContributor(strategies, (ConversionService)conversionService);
    }

    protected final List<ErrorResponse.Interceptor> getErrorResponseInterceptors() {
        if (this.errorResponseInterceptors == null) {
            this.errorResponseInterceptors = new ArrayList<ErrorResponse.Interceptor>();
            this.configureErrorResponseInterceptors(this.errorResponseInterceptors);
        }
        return this.errorResponseInterceptors;
    }

    protected void configureErrorResponseInterceptors(List<ErrorResponse.Interceptor> interceptors) {
    }

    static boolean isPresent(String name) {
        ClassLoader classLoader = WebMvcConfigurationSupport.class.getClassLoader();
        return ClassUtils.isPresent((String)name, (ClassLoader)classLoader);
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(@Nullable Object target, Errors errors) {
        }
    }
}

