/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.BeanInitializationException;
import infra.context.ApplicationContext;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.ObjectUtils;
import infra.web.accept.ContentNegotiationManager;
import infra.web.config.UrlBasedViewResolverRegistration;
import infra.web.view.BeanNameViewResolver;
import infra.web.view.ContentNegotiatingViewResolver;
import infra.web.view.View;
import infra.web.view.ViewResolver;
import infra.web.view.freemarker.FreeMarkerConfigurer;
import infra.web.view.freemarker.FreeMarkerViewResolver;
import infra.web.view.groovy.GroovyMarkupConfigurer;
import infra.web.view.groovy.GroovyMarkupViewResolver;
import infra.web.view.script.ScriptTemplateConfigurer;
import infra.web.view.script.ScriptTemplateViewResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ViewResolverRegistry {
    @Nullable
    private final ContentNegotiationManager contentNegotiationManager;
    @Nullable
    private final ApplicationContext applicationContext;
    @Nullable
    private ContentNegotiatingViewResolver contentNegotiatingResolver;
    private final ArrayList<ViewResolver> viewResolvers = new ArrayList(4);
    @Nullable
    private Integer order;

    public ViewResolverRegistry(@Nullable ContentNegotiationManager contentNegotiationManager, @Nullable ApplicationContext context) {
        this.applicationContext = context;
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public boolean hasRegistrations() {
        return this.contentNegotiatingResolver != null || !this.viewResolvers.isEmpty();
    }

    public void enableContentNegotiation(View ... defaultViews) {
        this.initContentNegotiatingViewResolver(defaultViews);
    }

    public void enableContentNegotiation(boolean useNotAcceptableStatus, View ... defaultViews) {
        ContentNegotiatingViewResolver vr = this.initContentNegotiatingViewResolver(defaultViews);
        vr.setUseNotAcceptableStatusCode(useNotAcceptableStatus);
    }

    private ContentNegotiatingViewResolver initContentNegotiatingViewResolver(View[] defaultViews) {
        this.order = this.order != null ? this.order : Integer.MIN_VALUE;
        if (this.contentNegotiatingResolver != null) {
            if (ObjectUtils.isNotEmpty((Object[])defaultViews) && CollectionUtils.isNotEmpty(this.contentNegotiatingResolver.getDefaultViews())) {
                ArrayList<View> views = new ArrayList<View>(this.contentNegotiatingResolver.getDefaultViews());
                CollectionUtils.addAll(views, (Object[])defaultViews);
                this.contentNegotiatingResolver.setDefaultViews(views);
            }
        } else {
            this.contentNegotiatingResolver = new ContentNegotiatingViewResolver();
            this.contentNegotiatingResolver.setDefaultViews(Arrays.asList(defaultViews));
            this.contentNegotiatingResolver.setViewResolvers(this.viewResolvers);
            if (this.contentNegotiationManager != null) {
                this.contentNegotiatingResolver.setContentNegotiationManager(this.contentNegotiationManager);
            }
        }
        return this.contentNegotiatingResolver;
    }

    public UrlBasedViewResolverRegistration freeMarker() {
        if (this.notFoundBeanOfType(FreeMarkerConfigurer.class)) {
            throw new BeanInitializationException("In addition to a FreeMarker view resolver there must also be a single FreeMarkerConfig bean in this web application context (or its parent): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.");
        }
        FreeMarkerRegistration registration = new FreeMarkerRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration groovy() {
        if (this.notFoundBeanOfType(GroovyMarkupConfigurer.class)) {
            throw new BeanInitializationException("In addition to a Groovy markup view resolver there must also be a single GroovyMarkupConfig bean in this web application context (or its parent): GroovyMarkupConfigurer is the usual implementation. This bean may be given any name.");
        }
        GroovyMarkupRegistration registration = new GroovyMarkupRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration scriptTemplate() {
        if (this.notFoundBeanOfType(ScriptTemplateConfigurer.class)) {
            throw new BeanInitializationException("In addition to a script template view resolver there must also be a single ScriptTemplateConfig bean in this web application context (or its parent): ScriptTemplateConfigurer is the usual implementation. This bean may be given any name.");
        }
        ScriptRegistration registration = new ScriptRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public void beanName() {
        BeanNameViewResolver resolver = new BeanNameViewResolver();
        this.viewResolvers.add(resolver);
    }

    public void viewResolver(ViewResolver viewResolver) {
        if (viewResolver instanceof ContentNegotiatingViewResolver) {
            throw new BeanInitializationException("addViewResolver cannot be used to configure a ContentNegotiatingViewResolver. Please use the method enableContentNegotiation instead.");
        }
        this.viewResolvers.add(viewResolver);
    }

    public void order(int order) {
        this.order = order;
    }

    private boolean notFoundBeanOfType(Class<?> beanType) {
        return this.applicationContext != null && CollectionUtils.isEmpty((Collection)BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)this.applicationContext, beanType, (boolean)false, (boolean)false));
    }

    protected int getOrder() {
        return this.order != null ? this.order : Integer.MAX_VALUE;
    }

    protected List<ViewResolver> getViewResolvers() {
        if (this.contentNegotiatingResolver != null) {
            return Collections.singletonList(this.contentNegotiatingResolver);
        }
        return this.viewResolvers;
    }

    private static class FreeMarkerRegistration
    extends UrlBasedViewResolverRegistration {
        public FreeMarkerRegistration() {
            super(new FreeMarkerViewResolver());
            this.getViewResolver().setSuffix(".ftl");
        }
    }

    private static class GroovyMarkupRegistration
    extends UrlBasedViewResolverRegistration {
        public GroovyMarkupRegistration() {
            super(new GroovyMarkupViewResolver());
            this.getViewResolver().setSuffix(".tpl");
        }
    }

    private static class ScriptRegistration
    extends UrlBasedViewResolverRegistration {
        public ScriptRegistration() {
            super(new ScriptTemplateViewResolver());
            this.getViewResolver();
        }
    }
}

