/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.config.EmbeddedValueResolver;
import infra.context.ApplicationContext;
import infra.context.support.ApplicationObjectSupport;
import infra.core.io.ClassPathResource;
import infra.core.io.Resource;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.lang.Version;
import infra.util.StringUtils;
import infra.web.InfraConfigurationException;
import infra.web.config.RedirectViewControllerRegistration;
import infra.web.config.ViewControllerRegistration;
import infra.web.handler.SimpleUrlHandlerMapping;
import infra.web.handler.mvc.ParameterizableViewController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ViewControllerRegistry
extends ApplicationObjectSupport {
    public static final String webMvcConfigLocation = "web-mvc.xml";
    public static final String DTD_NAME = "web-configuration";
    public static final String ATTR_RESOURCE = "resource";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PREFIX = "prefix";
    public static final String ATTR_SUFFIX = "suffix";
    public static final String ATTR_CONTENT_TYPE = "content-type";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_STATUS = "status";
    public static final String ELEMENT_ACTION = "action";
    public static final String ELEMENT_CONTROLLER = "controller";
    public static final String ROOT_ELEMENT = "Web-Configuration";
    private final List<ViewControllerRegistration> registrations = new ArrayList<ViewControllerRegistration>(4);
    private final List<RedirectViewControllerRegistration> redirectRegistrations = new ArrayList<RedirectViewControllerRegistration>(10);
    private int order = 1;
    protected EmbeddedValueResolver embeddedValueResolver;

    public ViewControllerRegistry(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
        this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)applicationContext.unwrapFactory(ConfigurableBeanFactory.class));
    }

    public ViewControllerRegistration addViewController(String pathPattern) {
        ViewControllerRegistration registration = new ViewControllerRegistration(pathPattern);
        registration.setApplicationContext(this.applicationContext);
        this.registrations.add(registration);
        return registration;
    }

    public ViewControllerRegistration addViewController(String pathPattern, Object resource) {
        return this.addViewController(pathPattern).setReturnValue(resource);
    }

    public RedirectViewControllerRegistration addRedirectViewController(String pathPattern, String redirectUrl) {
        RedirectViewControllerRegistration registration = new RedirectViewControllerRegistration(pathPattern, redirectUrl);
        registration.setApplicationContext(this.applicationContext);
        this.redirectRegistrations.add(registration);
        return registration;
    }

    public void addStatusController(String pathPattern, HttpStatusCode statusCode) {
        ViewControllerRegistration registration = new ViewControllerRegistration(pathPattern);
        registration.setApplicationContext(this.applicationContext);
        registration.setStatusCode(statusCode);
        registration.getViewController().setStatusOnly(true);
        this.registrations.add(registration);
    }

    public void addStatusController(String pathPattern, Integer status) {
        this.addStatusController(pathPattern, HttpStatusCode.valueOf(status));
    }

    public void registerWebViewXml() {
        ClassPathResource resource = new ClassPathResource(webMvcConfigLocation);
        if (resource.exists()) {
            this.logger.info("Using default web mvc configuration: '{}'", (Object)resource);
            this.registerWebViewXml((Resource)resource);
        } else {
            this.logger.warn("Web mvc configuration resource not found.");
        }
    }

    public void registerWebViewXml(Resource resource) {
        if (!resource.exists()) {
            throw new InfraConfigurationException("Your provided configuration location: [%s], does not exist".formatted(resource));
        }
        try {
            this.configure(resource);
        }
        catch (Exception e) {
            throw new InfraConfigurationException("%s xml parsing error".formatted(resource), e);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Nullable
    protected SimpleUrlHandlerMapping buildHandlerMapping() {
        if (this.registrations.isEmpty() && this.redirectRegistrations.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, ParameterizableViewController> urlMap = new LinkedHashMap<String, ParameterizableViewController>();
        for (ViewControllerRegistration viewControllerRegistration : this.registrations) {
            urlMap.put(viewControllerRegistration.getUrlPath(), viewControllerRegistration.getViewController());
        }
        for (RedirectViewControllerRegistration redirectViewControllerRegistration : this.redirectRegistrations) {
            urlMap.put(redirectViewControllerRegistration.getUrlPath(), redirectViewControllerRegistration.getViewController());
        }
        return new SimpleUrlHandlerMapping(urlMap, this.order);
    }

    protected void configure(Resource resource) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver((publicId, systemId) -> {
            if (systemId.contains(DTD_NAME) || publicId.contains(DTD_NAME)) {
                return new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes()));
            }
            return null;
        });
        try (InputStream inputStream = resource.getInputStream();){
            Element root = builder.parse(inputStream).getDocumentElement();
            if (ROOT_ELEMENT.equals(root.getNodeName())) {
                this.logger.debug("Found configuration file: [{}].", (Object)resource);
                NodeList nl = root.getChildNodes();
                int length = nl.getLength();
                for (int i = 0; i < length; ++i) {
                    Node node = nl.item(i);
                    if (!(node instanceof Element)) continue;
                    Element ele = (Element)node;
                    String nodeName = ele.getNodeName();
                    this.logger.debug("Found Element: [{}]", (Object)nodeName);
                    if (ELEMENT_CONTROLLER.equals(nodeName)) {
                        this.configController(ele);
                        continue;
                    }
                    this.logger.warn("This element: [{}] is not supported in this version: [{}].", (Object)nodeName, (Object)Version.instance);
                }
            }
        }
    }

    protected void configController(Element controller) {
        Assert.notNull((Object)controller, (String)"'controller' element can't be null");
        String prefix = controller.getAttribute(ATTR_PREFIX);
        String suffix = controller.getAttribute(ATTR_SUFFIX);
        NodeList nl = controller.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getNodeName();
            if (nodeName.equals(ELEMENT_ACTION)) {
                this.processAction(prefix, suffix, (Element)node);
                continue;
            }
            this.logger.warn("This element: [{}] is not supported.", (Object)nodeName);
        }
    }

    protected void processAction(String prefix, String suffix, Element action) {
        String path = action.getAttribute(ATTR_NAME);
        String resource = action.getAttribute(ATTR_RESOURCE);
        String contentType = action.getAttribute(ATTR_CONTENT_TYPE);
        String status = action.getAttribute(ATTR_STATUS);
        String type = action.getAttribute(ATTR_TYPE);
        if (StringUtils.isBlank((String)path)) {
            throw new InfraConfigurationException("You must specify a 'name' attribute like this: [<action resource=\"https://taketoday.cn\" name=\"TODAY-BLOG\" type=\"redirect\"/>]");
        }
        path = this.resolveEmbeddedVariables(path);
        path = StringUtils.prependLeadingSlash((String)path);
        if ("redirect".equals(type)) {
            RedirectViewControllerRegistration registration = this.addRedirectViewController(path, resource);
            if (StringUtils.isNotEmpty((CharSequence)status)) {
                registration.setStatusCode(HttpStatusCode.valueOf(Integer.parseInt(status)));
            }
        } else {
            ViewControllerRegistration registration = this.addViewController(path);
            if (StringUtils.isNotEmpty((CharSequence)status)) {
                registration.setStatusCode(HttpStatusCode.valueOf(Integer.parseInt(status)));
            }
            if (StringUtils.isNotEmpty((CharSequence)resource)) {
                String resourceAppender = prefix + resource + suffix;
                resource = this.resolveEmbeddedVariables(resourceAppender);
            }
            registration.setViewName(resource);
            if (StringUtils.isNotEmpty((CharSequence)contentType)) {
                registration.setContentType(contentType);
            }
        }
    }

    protected String resolveEmbeddedVariables(String expression) {
        return this.embeddedValueResolver.resolveStringValue(expression);
    }
}

