/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.context.ApplicationContext;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.HttpRequestHandler;
import infra.web.handler.mvc.ParameterizableViewController;
import java.util.function.Supplier;

public class ViewControllerRegistration {
    private final String urlPath;
    private final ParameterizableViewController controller = new ParameterizableViewController();

    public ViewControllerRegistration(String urlPath) {
        Assert.notNull((Object)urlPath, (String)"'urlPath' is required.");
        this.urlPath = urlPath;
    }

    public ViewControllerRegistration setStatusCode(HttpStatusCode statusCode) {
        this.controller.setStatusCode(statusCode);
        return this;
    }

    public ViewControllerRegistration setViewName(@Nullable String viewName) {
        this.controller.setViewName(viewName);
        return this;
    }

    public ViewControllerRegistration setContentType(String contentType) {
        this.controller.setContentType(contentType);
        return this;
    }

    public ViewControllerRegistration setReturnValue(Object returnValue) {
        this.controller.setReturnValue(returnValue);
        return this;
    }

    public ViewControllerRegistration setReturnValue(Supplier<Object> objectSupplier) {
        this.controller.setReturnValue(objectSupplier);
        return this;
    }

    public ViewControllerRegistration setReturnValue(HttpRequestHandler handler) {
        this.controller.setReturnValue(handler);
        return this;
    }

    protected void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.controller.setApplicationContext(applicationContext);
    }

    protected String getUrlPath() {
        return this.urlPath;
    }

    protected ParameterizableViewController getViewController() {
        return this.controller;
    }
}

